/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.FormattedHeader;
import org.apache.http.HeaderElement;
import org.apache.http.ParseException;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.HeaderValueParser;
import org.apache.http.util.CharArrayBuffer;

public class BufferedHeader
implements FormattedHeader {
    private final String name;
    private final CharArrayBuffer buffer;
    private final int valuePos;
    private HeaderValueParser parser;

    public BufferedHeader(CharArrayBuffer buffer, HeaderValueParser parser) throws ParseException {
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        int colon = buffer.indexOf(58);
        if (colon == -1) {
            throw new ParseException("Invalid header: " + buffer.toString());
        }
        String s = buffer.substringTrimmed(0, colon);
        if (s.length() == 0) {
            throw new ParseException("Invalid header: " + buffer.toString());
        }
        this.buffer = buffer;
        this.name = s;
        this.valuePos = colon + 1;
        this.parser = parser;
    }

    public BufferedHeader(CharArrayBuffer buffer) throws ParseException {
        this(buffer, null);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.buffer.substringTrimmed(this.valuePos, this.buffer.length());
    }

    public HeaderValueParser getParser() {
        return this.parser;
    }

    public void setParser(HeaderValueParser parser) {
        this.parser = parser;
    }

    public HeaderElement[] getElements() throws ParseException {
        HeaderValueParser hvp = this.parser;
        if (hvp == null) {
            hvp = BasicHeaderValueParser.DEFAULT;
        }
        return hvp.parseElements(this.buffer, this.valuePos, this.buffer.length());
    }

    public int getValuePos() {
        return this.valuePos;
    }

    public CharArrayBuffer getBuffer() {
        return this.buffer;
    }

    public String toString() {
        return this.buffer.toString();
    }
}

