/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.exception;

import br.com.sankhya.sps.exception.ErrorCode;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class BaseException
extends RuntimeException {
    private static final long serialVersionUID = 1550014661051644308L;
    private ErrorCode errorCode;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public BaseException(ErrorCode errorCode) {
        super(errorCode.getDefaultMessage());
        this.errorCode = errorCode;
    }

    public BaseException(ErrorCode errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
    }

    public BaseException(ErrorCode errorCode, Throwable cause) {
        super(errorCode.getDefaultMessage(), cause);
        this.errorCode = errorCode;
    }

    public BaseException(ErrorCode errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public <T> T get(String key) {
        return (T)this.properties.get(key);
    }

    public BaseException put(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            this.printStackTrace(new PrintWriter(s));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            s.println(this);
            s.println("\t-------------------------------");
            if (this.errorCode != null) {
                s.println("\t" + this.errorCode + ":" + this.errorCode.getClass().getName());
            }
            for (String key : this.properties.keySet()) {
                s.println("\t" + key + "=[" + this.properties.get(key) + "]");
            }
            s.println("\t-------------------------------");
            StackTraceElement[] trace = this.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                s.println("\tat " + trace[i]);
            }
            Throwable ourCause = this.getCause();
            if (ourCause != null) {
                ourCause.printStackTrace(s);
            }
            s.flush();
        }
    }
}

