/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.crypto;

import br.com.sankhya.sps.crypto.Encryptor;
import br.com.sankhya.sps.crypto.exception.CryptoErrorCode;
import br.com.sankhya.sps.crypto.exception.CryptoException;
import br.com.sankhya.sps.util.Preconditions;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class HmacSHA1Encriptor
implements Encryptor {
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private String secretKey;
    private String salt;

    public HmacSHA1Encriptor(String secretKey, String salt) {
        Preconditions.checkNotNull(secretKey, "A secret key n\u00e3o pode ser nula");
        Preconditions.checkNotNull(salt, "o salt n\u00e3o pode ser nulo");
        this.secretKey = secretKey;
        this.salt = salt;
    }

    @Override
    public String encrypt(String toEncrypt) throws CryptoException {
        try {
            String message = toEncrypt + this.salt;
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            SecretKeySpec keySpec = new SecretKeySpec(this.secretKey.getBytes(), HMAC_SHA1_ALGORITHM);
            mac.init(keySpec);
            byte[] hashBytes = mac.doFinal(message.getBytes());
            byte[] encodedHash = Base64.encodeBase64((byte[])hashBytes);
            char[] encodedHex = Hex.encodeHex((byte[])encodedHash);
            String encoded = String.valueOf(encodedHex);
            return encoded;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(CryptoErrorCode.ALGORITHM_NOT_FOUND);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(CryptoErrorCode.INVALID_KEY);
        }
        catch (Exception e) {
            throw new CryptoException(CryptoErrorCode.CRYPTO_ERROR);
        }
    }
}

