/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.conversion.w3c;

import br.com.sankhya.sps.conversion.Converter;
import br.com.sankhya.sps.conversion.exception.ConversionErrorCode;
import br.com.sankhya.sps.conversion.exception.ConversionException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class StringToW3CDocumentConverter
implements Converter<String, Document> {
    @Override
    public Document convert(String source) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            ByteArrayInputStream stream = new ByteArrayInputStream(source.getBytes());
            Document document = db.parse(stream);
            return document;
        }
        catch (ParserConfigurationException e) {
            throw new ConversionException(ConversionErrorCode.CANNOT_CONVERT_STRING, "Ocorreu um erro ao configurar o conversor de String em Document", (Throwable)e);
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new ConversionException(ConversionErrorCode.CANNOT_CONVERT_STRING, "Ocorreu um erro durante a convers\u00e3o da String em Document", (Throwable)e);
        }
        catch (IOException e) {
            throw new ConversionException(ConversionErrorCode.CANNOT_CONVERT_STRING, "Ocorreu um erro de IO durante a convers\u00e3o da String em Document", (Throwable)e);
        }
        catch (Exception e) {
            throw new ConversionException(ConversionErrorCode.CANNOT_CONVERT_STRING, (Throwable)e);
        }
    }
}

