/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.conversion.jdom.element;

import br.com.sankhya.sps.conversion.Converter;
import br.com.sankhya.sps.exception.BaseException;
import br.com.sankhya.sps.util.XmlUtil;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Element;

public abstract class AbstractBaseExceptionToElementConverter<T extends BaseException>
implements Converter<T, Element> {
    @Override
    public Element convert(T baseException) {
        Element root = null;
        try {
            root = new Element("error");
            if (baseException != null) {
                XmlUtil.addSimpleElement(root, "errorCode", ((BaseException)baseException).getErrorCode().getCode());
                XmlUtil.addSimpleElement(root, "errorMessage", ((Throwable)baseException).getMessage());
                this.convertProperties((BaseException)baseException, root);
            }
        }
        catch (Exception e) {
            this.throwConversionException(e);
        }
        return root;
    }

    protected abstract void throwConversionException(Exception var1);

    private void convertProperties(BaseException baseException, Element root) {
        Map<String, Object> properties = baseException.getProperties();
        if (properties.size() > 0) {
            Element propertiesElement = new Element("properties");
            root.addContent((Content)propertiesElement);
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                XmlUtil.addSimpleElement(propertiesElement, entry.getKey(), entry.getValue());
            }
        }
    }
}

