/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.conversion;

import br.com.sankhya.sps.conversion.Converter;
import br.com.sankhya.sps.conversion.exception.ConversionErrorCode;
import br.com.sankhya.sps.conversion.exception.ConversionException;
import java.util.HashMap;
import java.util.Map;

public class ConversionUtil {
    private Map<String, Converter> converters = new HashMap<String, Converter>();

    public <S, T> T convert(S source, Class<S> sourceType, Class<T> targetType, String subConverter) {
        if (source == null) {
            throw new IllegalArgumentException("O objeto a ser convertido n\u00e3o pode ser nulo");
        }
        if (sourceType == null) {
            throw new IllegalArgumentException("A classe de origem n\u00e3o pode ser nula");
        }
        if (targetType == null) {
            throw new IllegalArgumentException("A classe de destino n\u00e3o pode ser nula");
        }
        String converterName = null;
        converterName = subConverter == null ? this.getDefaultConverterName(sourceType, targetType) : this.getSubTypeConverterName(sourceType, targetType, subConverter);
        Converter converter = this.converters.get(converterName);
        if (converter == null) {
            throw new ConversionException(ConversionErrorCode.CANNOT_FIND_CONVERTER, "N\u00e3o foi poss\u00edvel encontrar um conversor de " + sourceType.getName() + " para " + targetType.getName());
        }
        Object t = converter.convert(source);
        return t;
    }

    public <S, T> T convert(S source, Class<S> sourceType, Class<T> targetType) {
        return this.convert(source, sourceType, targetType, null);
    }

    public <S, T> T convert(S source, Class<T> targetType, String subConverter) {
        if (source == null) {
            throw new IllegalArgumentException("O objeto a ser convertido n\u00e3o pode ser nulo");
        }
        Class<?> sourceType = source.getClass();
        return this.convert(source, sourceType, targetType, subConverter);
    }

    public <S, T> T convert(S source, Class<T> targetType) {
        if (source == null) {
            throw new IllegalArgumentException("O objeto a ser convertido n\u00e3o pode ser nulo");
        }
        Class<?> sourceType = source.getClass();
        return this.convert(source, sourceType, targetType, null);
    }

    public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        return this.canConvert(sourceType, targetType, null);
    }

    public boolean canConvert(Class<?> sourceType, Class<?> targetType, String subConverter) {
        String converterName = null;
        converterName = subConverter == null ? this.getDefaultConverterName(sourceType, targetType) : this.getSubTypeConverterName(sourceType, targetType, subConverter);
        return this.converters.get(converterName) != null;
    }

    private String getDefaultConverterName(Class<?> sourceType, Class<?> targetType) {
        return sourceType.getCanonicalName() + "_" + targetType.getCanonicalName();
    }

    private String getSubTypeConverterName(Class<?> sourceType, Class<?> targetType, String subConverter) {
        return sourceType.getCanonicalName() + "_" + targetType.getCanonicalName() + "_" + subConverter;
    }

    public <S, T> void registryConverter(Class<S> sourceType, Class<T> targetType, Converter<S, T> converter) {
        String key = this.getDefaultConverterName(sourceType, targetType);
        this.converters.put(key, converter);
    }

    public <S, T> void registryConverter(Class<S> sourceType, Class<T> targetType, Converter<S, T> converter, String subConverter) {
        String key = this.getSubTypeConverterName(sourceType, targetType, subConverter);
        this.converters.put(key, converter);
    }
}

