/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util.xml;

import com.sankhya.util.xml.AbstractXMLElement;
import com.sankhya.util.xml.XMLAttributeValidator;
import java.io.InputStream;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SimpleSAXParser
extends DefaultHandler {
    private AbstractXMLElement currentXMLElement;
    private AbstractXMLElement root;
    private Map xmlElements = new HashMap();
    private Map requiredXmlElements = new HashMap();
    private Stack elementsStack;

    public void registryXMLElementClass(String elementName, Class elementClass) {
        this.registryXMLElementClass(elementName, elementClass, false);
    }

    public void registryXMLElementClass(String elementName, Class elementClass, boolean required) {
        this.xmlElements.put(elementName, elementClass);
        if (required) {
            this.requiredXmlElements.put(elementName, Boolean.FALSE);
        }
    }

    public AbstractXMLElement getRoot() {
        return this.root;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.xmlElements.get(qName) != null) {
            AbstractXMLElement parent = null;
            try {
                parent = (AbstractXMLElement)this.elementsStack.pop();
            }
            catch (EmptyStackException ignored) {
                // empty catch block
            }
            this.currentXMLElement.formatContent();
            if (parent != null) {
                parent.addChild(this.currentXMLElement, qName);
                this.currentXMLElement.endElement();
                this.currentXMLElement = parent;
            } else {
                this.currentXMLElement.endElement();
            }
        }
    }

    public void parse(InputStream in) throws Exception {
        this.parse(in, null);
    }

    public void parse(InputStream in, AbstractXMLElement parentElement) throws Exception {
        this.elementsStack = new Stack();
        this.currentXMLElement = parentElement;
        this.root = null;
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser saxParser = spf.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setContentHandler(this);
        xmlReader.setErrorHandler(this);
        InputSource inSource = new InputSource(in);
        this.clearRequiredStatus();
        xmlReader.parse(inSource);
        this.verifyRequiredElements();
    }

    @Override
    public synchronized void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        block9: {
            Class elementClass = (Class)this.xmlElements.get(qName);
            try {
                if (elementClass != null) {
                    AbstractXMLElement parent;
                    if (this.requiredXmlElements.get(qName) != null) {
                        this.requiredXmlElements.put(qName, Boolean.TRUE);
                    }
                    if ((parent = this.currentXMLElement) != null) {
                        this.elementsStack.push(parent);
                    }
                    this.currentXMLElement = (AbstractXMLElement)elementClass.newInstance();
                    this.currentXMLElement.setParent(parent);
                    this.currentXMLElement.handleElement(atts, parent);
                    if (this.root == null) {
                        this.root = this.currentXMLElement;
                    }
                    break block9;
                }
                if (qName.equals("property")) {
                    XMLAttributeValidator.validate(atts, "property", "name,value");
                    if (this.currentXMLElement == null) {
                        throw new IllegalStateException("Formato do XML inv\u00e1lido, 'property' sem elemento de liga\u00e7\u00e3o");
                    }
                    this.currentXMLElement.addProperty(atts.getValue("name"), atts.getValue("value"));
                    break block9;
                }
                throw new IllegalStateException("Sem handle para este elemento: " + qName);
            }
            catch (Exception e) {
                if (e instanceof SAXException) {
                    throw (SAXException)e;
                }
                SAXException error = new SAXException(e.getMessage());
                error.initCause(e);
                throw error;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentXMLElement != null) {
            this.currentXMLElement.setContent(ch, start, length);
        }
    }

    private void clearRequiredStatus() {
        for (Map.Entry entry : this.requiredXmlElements.entrySet()) {
            entry.setValue(Boolean.FALSE);
        }
    }

    private void verifyRequiredElements() throws SAXException {
        for (Map.Entry entry : this.requiredXmlElements.entrySet()) {
            if (!entry.getValue().equals(Boolean.FALSE)) continue;
            throw new SAXException("Elemento requerido faltando: " + entry.getKey());
        }
    }
}

