/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class AbstractXMLElement
implements Serializable {
    private AbstractXMLElement parent;
    private Map childs;
    private Map childsById;
    private Map properties = new HashMap();
    private StringBuffer content;

    public AbstractXMLElement() {
        this.childs = new HashMap();
        this.childsById = new HashMap();
        this.content = new StringBuffer();
    }

    public abstract String getIdentifier();

    public Collection getChildByName(String name) {
        Collection c = (Collection)this.childs.get(name);
        return c == null ? new ArrayList() : c;
    }

    public AbstractXMLElement getChildByName(String name, String identifier) {
        AbstractXMLElement foundElement = null;
        Collection childsCol = this.getChildByName(name);
        if (childsCol != null && childsCol.size() > 0) {
            for (AbstractXMLElement currentElement : childsCol) {
                String elementID = currentElement.getIdentifier();
                if (elementID == null || !elementID.equals(identifier)) continue;
                foundElement = currentElement;
                break;
            }
        }
        return foundElement;
    }

    public Map getChilds() {
        return this.childs;
    }

    public Map getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        return (String)this.properties.get(name);
    }

    public void addChild(AbstractXMLElement childElement, String name) throws SAXException {
        ArrayList<AbstractXMLElement> c = (ArrayList<AbstractXMLElement>)this.childs.get(name);
        if (c == null) {
            c = new ArrayList<AbstractXMLElement>();
            this.childs.put(name, c);
            this.childsById.put(name, new HashMap());
        }
        Map ids = (Map)this.childsById.get(name);
        if (childElement.isUnique()) {
            if (ids.containsKey(childElement.getIdentifier())) {
                throw new SAXException("Identificador \u00fanico violado no elemento '" + name + "': " + childElement.getIdentifier());
            }
            ids.put(childElement.getIdentifier(), null);
        }
        c.add(childElement);
    }

    public void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public void endElement() {
    }

    public abstract void handleElement(Attributes var1, AbstractXMLElement var2) throws SAXException;

    public AbstractXMLElement getParent() {
        return this.parent;
    }

    public void setParent(AbstractXMLElement parent) {
        this.parent = parent;
    }

    public String getContent() {
        return this.content.toString();
    }

    public void setContent(char[] content, int start, int len) {
        this.content.append(content, start, len);
    }

    public AbstractXMLElement searchByElement(String elementName, String path) {
        int dotIndex = path.indexOf(46);
        String thisNode = path.substring(0, dotIndex == -1 ? path.length() : dotIndex);
        AbstractXMLElement child = this.getChildByName(elementName, thisNode);
        if (child != null && dotIndex > -1) {
            return child.searchByElement(elementName, path.substring(dotIndex + 1));
        }
        return child;
    }

    public void formatContent() {
        if (this.content.length() > 0) {
            String text = this.content.toString();
            this.content.delete(0, this.content.length());
            this.content.append(text.replaceAll("\n", "").trim());
        }
    }

    public boolean isUnique() {
        return false;
    }

    private class ChildEntry {
        Collection childs = new ArrayList();
        Map childsId = new HashMap();

        private ChildEntry() {
        }
    }
}

