/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util.io;

import com.sankhya.util.CustomByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class DiskList
implements List {
    private static final int INSERTIONSORT_THRESHOLD = 7;
    private ByteArrayInputStream inputStream;
    private CustomByteArrayOutputStream outputStream;
    private File diskFile;
    private List rows;
    private ObjectIO objectIO;
    private RandomAccessFile file;
    private Object[] buffer;
    private byte[] inputStreamBuff;
    private int bufSize;
    private int endBufIndex;
    private int iniBufIndex;
    private int maxRowLength;
    private int numAdds;
    private int numGets;
    private int numSets;

    public DiskList(ObjectIO objectIO, int bufSize, int maxRowLength) {
        this.objectIO = objectIO;
        if (bufSize <= 0) {
            bufSize = 1;
        }
        if (maxRowLength <= 0) {
            throw new IllegalArgumentException("O maior conte\u00fado de cada linha deve ser maior que zero.");
        }
        this.bufSize = bufSize;
        this.maxRowLength = maxRowLength;
        this.rows = new ArrayList();
        this.buffer = new Object[bufSize];
        this.iniBufIndex = Integer.MAX_VALUE;
        this.endBufIndex = Integer.MIN_VALUE;
        this.numAdds = 0;
        this.numSets = 0;
        this.numGets = 0;
    }

    @Override
    public boolean add(Object o) {
        try {
            if (this.file == null) {
                this.diskFile = File.createTempFile("DiskList", "tmp");
                this.file = new RandomAccessFile(this.diskFile, "rw");
                this.outputStream = new CustomByteArrayOutputStream(this.maxRowLength);
                this.inputStreamBuff = new byte[this.maxRowLength];
                this.inputStream = new ByteArrayInputStream(this.inputStreamBuff);
                this.inputStream.mark(0);
            }
            this.file.seek(this.file.length() + 1L);
            Long offset = new Long(this.file.getFilePointer());
            this.outputStream.reset();
            this.objectIO.writeObject(new DataOutputStream(this.outputStream), o);
            this.rows.add(new Row(offset, this.objectIO.getPKsList(o), this.outputStream.size()));
            this.file.write(this.outputStream.getInternalBuffer());
            ++this.numAdds;
            return true;
        }
        catch (Exception e) {
            IllegalStateException error = new IllegalStateException();
            error.initCause(e);
            throw error;
        }
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        try {
            if (this.file != null) {
                this.file.setLength(0L);
            }
            this.rows.clear();
            this.iniBufIndex = Integer.MAX_VALUE;
            this.endBufIndex = Integer.MIN_VALUE;
        }
        catch (Exception e) {
            IllegalStateException error = new IllegalStateException();
            error.initCause(e);
            throw error;
        }
    }

    public void close() {
        try {
            if (this.file != null) {
                this.file.close();
                this.file = null;
            }
            if (this.diskFile != null) {
                this.diskFile.delete();
                this.diskFile = null;
            }
            this.rows.clear();
        }
        catch (IOException e) {
            IllegalStateException error = new IllegalStateException();
            error.initCause(e);
            throw error;
        }
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public Object get(int index) {
        this.rangeCheck(index);
        this.updateBuffer(index);
        ++this.numGets;
        return this.buffer[index - this.iniBufIndex];
    }

    public String getInfo() {
        return "numLinhas=" + this.rows.size() + ", numSets=" + this.numSets + ", numAdds=" + this.numAdds + ", numGets=" + this.numGets;
    }

    public Object[] getPKs(int index) {
        this.rangeCheck(index);
        return ((Row)this.rows.get(index)).pks;
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            Iterator rowsIterator;
            {
                this.rowsIterator = DiskList.this.rows.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.rowsIterator.hasNext();
            }

            public Object next() {
                Row row = (Row)this.rowsIterator.next();
                return DiskList.this.getObject(row);
            }

            @Override
            public void remove() {
                this.rowsIterator.remove();
                DiskList.this.iniBufIndex = Integer.MAX_VALUE;
                DiskList.this.endBufIndex = Integer.MIN_VALUE;
            }
        };
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    public ListIterator listIterator() {
        throw new UnsupportedOperationException();
    }

    public ListIterator listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int index) {
        this.rangeCheck(index);
        Object o = this.getObject((Row)this.rows.get(index));
        this.rows.remove(index);
        this.iniBufIndex = Integer.MAX_VALUE;
        this.endBufIndex = Integer.MIN_VALUE;
        return o;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public void removeWithoutReturn(int index) {
        this.rangeCheck(index);
        this.rows.remove(index);
        this.iniBufIndex = Integer.MAX_VALUE;
        this.endBufIndex = Integer.MIN_VALUE;
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public Object set(int index, Object o) {
        try {
            this.rangeCheck(index);
            Row row = (Row)this.rows.get(index);
            Row updateRow = new Row(row.offset, this.objectIO.getPKsList(o), row.rowLength);
            this.rows.set(index, updateRow);
            this.file.seek(row.offset);
            this.outputStream.reset();
            this.objectIO.writeObject(new DataOutputStream(this.outputStream), o);
            this.file.write(this.outputStream.getInternalBuffer());
            if (index >= this.iniBufIndex && index <= this.endBufIndex) {
                this.buffer[index - this.iniBufIndex] = o;
            }
            ++this.numSets;
            return null;
        }
        catch (Exception e) {
            IllegalStateException error = new IllegalStateException();
            error.initCause(e);
            throw error;
        }
    }

    @Override
    public int size() {
        return this.rows.size();
    }

    public void sort(Comparator c) {
        List a = this.rows;
        ArrayList aux = new ArrayList();
        aux.addAll(a);
        this.mergeSort(aux, a, 0, a.size(), 0, c);
    }

    public void sortByPKs(final Comparator c) {
        List a = this.rows;
        ArrayList aux = new ArrayList();
        aux.addAll(a);
        this.mergeSortByPKs(aux, a, 0, a.size(), 0, new Comparator(){

            public int compare(Object o1, Object o2) {
                Row r1 = (Row)o1;
                Row r2 = (Row)o2;
                return c.compare(r1.pks, r2.pks);
            }
        });
    }

    public List subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray(Object[] a) {
        throw new UnsupportedOperationException();
    }

    private Object getObject(Row row) {
        try {
            Object obj;
            this.file.seek(row.offset);
            this.file.read(this.inputStreamBuff, 0, row.rowLength);
            Object object = obj = this.objectIO.readObject(new DataInputStream(this.inputStream));
            return object;
        }
        catch (Exception e) {
            IllegalStateException error = new IllegalStateException();
            error.initCause(e);
            throw error;
        }
        finally {
            this.inputStream.reset();
        }
    }

    private void mergeSort(List src, List dest, int low, int high, int off, Comparator c) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && c.compare(this.getObject((Row)dest.get(j - 1)), this.getObject((Row)dest.get(j))) > 0; --j) {
                    this.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >> 1;
        this.mergeSort(dest, src, low, mid, -off, c);
        this.mergeSort(dest, src, mid, high, -off, c);
        if (c.compare(this.getObject((Row)src.get(mid - 1)), this.getObject((Row)src.get(mid))) <= 0) {
            for (int i = 0; i < length; ++i) {
                dest.set(i + destLow, src.get(i + low));
            }
            return;
        }
        int p = low;
        int q = mid;
        for (int i = destLow; i < destHigh; ++i) {
            if (q >= high || p < mid && c.compare(this.getObject((Row)src.get(p)), this.getObject((Row)src.get(q))) <= 0) {
                dest.set(i, src.get(p++));
                continue;
            }
            dest.set(i, src.get(q++));
        }
    }

    private void mergeSortByPKs(List src, List dest, int low, int high, int off, Comparator c) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && c.compare(dest.get(j - 1), dest.get(j)) > 0; --j) {
                    this.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >> 1;
        this.mergeSortByPKs(dest, src, low, mid, -off, c);
        this.mergeSortByPKs(dest, src, mid, high, -off, c);
        if (c.compare(src.get(mid - 1), src.get(mid)) <= 0) {
            for (int i = 0; i < length; ++i) {
                dest.set(i + destLow, src.get(i + low));
            }
            return;
        }
        int p = low;
        int q = mid;
        for (int i = destLow; i < destHigh; ++i) {
            if (q >= high || p < mid && c.compare(src.get(p), src.get(q)) <= 0) {
                dest.set(i, src.get(p++));
                continue;
            }
            dest.set(i, src.get(q++));
        }
    }

    private void rangeCheck(int index) {
        if (index >= this.rows.size() || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.rows.size());
        }
    }

    private void swap(List x, int a, int b) {
        Object t = x.get(a);
        x.set(a, x.get(b));
        x.set(b, t);
    }

    private void updateBuffer(int index) {
        if (index < this.iniBufIndex || index > this.endBufIndex) {
            int newEndBufIndex;
            int newIniBufIndex = index - this.bufSize / 2 < 0 ? 0 : index - this.bufSize / 2;
            int n = newEndBufIndex = newIniBufIndex + this.bufSize - 1 >= this.rows.size() ? this.rows.size() - 1 : newIniBufIndex + this.bufSize - 1;
            if (newIniBufIndex >= this.iniBufIndex && newIniBufIndex <= this.endBufIndex) {
                int i;
                for (i = newIniBufIndex; i <= this.endBufIndex; ++i) {
                    this.buffer[i - newIniBufIndex] = this.buffer[i - this.iniBufIndex];
                }
                for (i = this.endBufIndex + 1; i <= newEndBufIndex; ++i) {
                    this.buffer[i - newIniBufIndex] = this.getObject((Row)this.rows.get(i));
                }
            } else if (newEndBufIndex <= this.endBufIndex && newEndBufIndex >= this.iniBufIndex) {
                int i;
                for (i = this.iniBufIndex; i <= newEndBufIndex; ++i) {
                    this.buffer[i - newIniBufIndex] = this.buffer[i - this.iniBufIndex];
                }
                for (i = newIniBufIndex; i < this.iniBufIndex; ++i) {
                    this.buffer[i - newIniBufIndex] = this.getObject((Row)this.rows.get(i));
                }
            } else {
                for (int i = newIniBufIndex; i <= newEndBufIndex; ++i) {
                    this.buffer[i - newIniBufIndex] = this.getObject((Row)this.rows.get(i));
                }
            }
            this.iniBufIndex = newIniBufIndex;
            this.endBufIndex = newEndBufIndex;
        }
    }

    public static class Row {
        private Long offset;
        private Object[] pks;
        private int rowLength;

        public Row(Long offset, Object[] pks, int rowLength) {
            this.offset = offset;
            this.pks = pks;
            this.rowLength = rowLength;
        }

        public int getLength() {
            return this.rowLength;
        }

        public Long getOffset() {
            return this.offset;
        }

        public Object[] getPks() {
            return this.pks;
        }
    }

    public static interface ObjectIO {
        public Object[] getPKsList(Object var1);

        public Object readObject(DataInputStream var1) throws Exception;

        public void writeObject(DataOutputStream var1, Object var2) throws Exception;
    }
}

