/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    public static void main(String[] args) throws Exception {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        map.put("/teste/arq1.txt", "conteudo do arquivo 1".getBytes());
        map.put("/teste/pasta2/arq2.txt", "conteudo do arquivo 2".getBytes());
        map.put("/teste/pasta2/pasta3/arq3.txt", "conteudo do arquivo 3".getBytes());
        FileOutputStream fos = new FileOutputStream(new File("d:/temp/daniel.zip"));
        fos.write(ZipUtils.zip(map));
        fos.flush();
        fos.close();
    }

    public static byte[] zip(Map<String, byte[]> entriesNamesAndContents) throws Exception {
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream(1024);
        ZipOutputStream zos = new ZipOutputStream(byteArray);
        for (Map.Entry<String, byte[]> entry : entriesNamesAndContents.entrySet()) {
            zos.putNextEntry(new ZipEntry(entry.getKey()));
            zos.write(entry.getValue());
            zos.flush();
            zos.closeEntry();
        }
        zos.close();
        return byteArray.toByteArray();
    }

    public static byte[] zip(String entryName, byte[] content) throws IOException {
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream(1024);
        ZipOutputStream zos = new ZipOutputStream(byteArray);
        zos.putNextEntry(new ZipEntry(entryName));
        zos.write(content);
        zos.flush();
        zos.closeEntry();
        zos.close();
        return byteArray.toByteArray();
    }

    public static void zipDirectory(File dir, String zipFilePath, boolean includeRoot) throws IOException {
        int offset;
        byte[] buffer = new byte[2048];
        List<String> fileNames = ZipUtils.recListFiles(dir);
        fileNames.add(dir.getAbsolutePath());
        FileOutputStream fos = new FileOutputStream(zipFilePath);
        ZipOutputStream zos = new ZipOutputStream(fos);
        if (includeRoot) {
            offset = dir.getParent().length() + 1;
        } else {
            offset = dir.getAbsolutePath().length() + 1;
            fileNames.remove(dir.getAbsolutePath());
        }
        for (String fileName : fileNames) {
            String normalizedFileName = fileName.substring(offset).replaceAll("/", "\\");
            boolean isFile = new File(fileName).isFile();
            if (isFile) {
                int len;
                ZipEntry ze = new ZipEntry(normalizedFileName);
                zos.putNextEntry(ze);
                FileInputStream in = new FileInputStream(fileName);
                while ((len = ((InputStream)in).read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
            }
            zos.flush();
            zos.closeEntry();
        }
        zos.close();
        fos.close();
    }

    private static void recursiveFileFind(File dir, List<String> fileList) {
        File[] list;
        for (File file : list = dir.listFiles()) {
            fileList.add(file.getAbsolutePath());
            if (!file.isDirectory()) continue;
            ZipUtils.recursiveFileFind(file, fileList);
        }
    }

    private static List<String> recListFiles(File dir) {
        ArrayList<String> list = new ArrayList<String>();
        ZipUtils.recursiveFileFind(dir, list);
        return list;
    }
}

