/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import com.sankhya.util.BigDecimalUtil;
import com.sankhya.util.StringUtils;
import com.sankhya.util.TimeUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.InputSource;

public class XMLUtils {
    public static void addAttributeElement(Element elem, String name, Object value) {
        elem.setAttribute(name, value != null ? value.toString() : "");
    }

    public static void addAttributeElement(Element elem, String name, ResultSet rs) throws Exception {
        Object value = rs.getObject(name);
        XMLUtils.addAttributeElement(elem, name, value);
    }

    public static void addContentElement(Element parent, String name, ResultSet rs) throws Exception {
        Object value = rs.getObject(name);
        XMLUtils.addContentElement(parent, name, value);
    }

    public static void addContentElement(Element parent, String name, Object value) throws Exception {
        XMLUtils.addContentElement(parent, name, value, null, null);
    }

    public static void addContentElement(Element parent, String name, Object value, Namespace namespace) throws Exception {
        XMLUtils.addContentElement(parent, name, value, null, namespace);
    }

    public static void addContentElement(Element parent, String name, Object value, Attribute[] attributes) throws Exception {
        XMLUtils.addContentElement(parent, name, value, attributes, null);
    }

    public static void addContentElement(Element parent, String name, Object value, Attribute[] attributes, Namespace namespace) throws Exception {
        Element content = new Element(name);
        if (namespace != null) {
            content.setNamespace(namespace);
        }
        content.setText(value != null ? value.toString() : "");
        if (attributes != null) {
            for (int i = 0; i < attributes.length; ++i) {
                content.setAttribute(attributes[i]);
            }
        }
        parent.addContent((Content)content);
    }

    public static Element buildCDATAElement(String name, String value) throws Exception {
        Element content = new Element(name);
        content.addContent((Content)new CDATA(value));
        return content;
    }

    public static void addCDATAContentElement(Element parent, String name, String value) throws Exception {
        parent.addContent((Content)XMLUtils.buildCDATAElement(name, value));
    }

    public static Document buildDocumentFromStream(InputStream is) throws Exception {
        SAXBuilder saxBuilder = new SAXBuilder();
        Document doc = saxBuilder.build(is);
        is.close();
        return doc;
    }

    public static Document buildDocumentFromString(String source) throws Exception {
        InputSource is = new InputSource(new StringReader(source));
        SAXBuilder saxBuilder = new SAXBuilder();
        Document doc = saxBuilder.build(is);
        return doc;
    }

    public static Element buildXMLElementFromObject(Object obj, String rootName, Map elementNameByObjProperty) throws Exception {
        Class<?> clazz = obj.getClass();
        Field[] fields = clazz.getDeclaredFields();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        Element rootElem = new Element(rootName);
        for (int i = 0; i < fields.length; ++i) {
            fields[i].setAccessible(true);
            Element fieldElem = null;
            fieldElem = elementNameByObjProperty == null || elementNameByObjProperty.get(fields[i].getName()) == null ? new Element(fields[i].getName().toUpperCase()) : new Element((String)elementNameByObjProperty.get(fields[i].getName()));
            Object value = fields[i].get(obj);
            if (value != null) {
                if (Date.class.isAssignableFrom(fields[i].getClass())) {
                    fieldElem.setText(sdf.format(value));
                } else {
                    fieldElem.setText(value.toString());
                }
            }
            rootElem.addContent((Content)fieldElem);
        }
        return rootElem;
    }

    public static Element buildXMLElementFromObject(Object obj, String rootName) throws Exception {
        return XMLUtils.buildXMLElementFromObject(obj, rootName, null);
    }

    public static Element buildXMLFromResultSet(String parentName, String childName, ResultSet rset, RowBuilder rowBuilder) throws Exception {
        ResultSetMetaData rsmd = rset.getMetaData();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        HashMap<String, BigDecimal> sum = null;
        if (rowBuilder != null && rowBuilder.getSumColumns() != null) {
            sum = new HashMap<String, BigDecimal>();
            for (String sumColName : rowBuilder.getSumColumns()) {
                sum.put(sumColName.toUpperCase(), BigDecimal.ZERO);
            }
        }
        Element parentElem = new Element(parentName);
        while (rset.next()) {
            Element childElem = new Element(childName);
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                String col = rsmd.getColumnLabel(i).toUpperCase();
                Class<?> type = Class.forName(rsmd.getColumnClassName(i));
                Object value = null;
                if (Number.class.isAssignableFrom(type)) {
                    value = rset.getBigDecimal(i);
                    if (sum != null && sum.containsKey(col)) {
                        sum.put(col, ((BigDecimal)sum.get(col)).add(BigDecimalUtil.getValueOrZero((BigDecimal)value)));
                    }
                } else if (Date.class.isAssignableFrom(type)) {
                    value = rset.getTimestamp(i);
                } else {
                    if (!String.class.isAssignableFrom(type)) continue;
                    value = rset.getString(i);
                }
                if (rowBuilder != null && rowBuilder.acceptColumn(col)) {
                    value = rowBuilder.formatColumn(value, col);
                }
                if (rowBuilder != null && !rowBuilder.acceptColumn(col)) continue;
                if (value instanceof Timestamp && value != null) {
                    XMLUtils.addContentElement(childElem, col, sdf.format(value));
                    continue;
                }
                XMLUtils.addContentElement(childElem, col, value);
            }
            if (rowBuilder != null) {
                rowBuilder.addCalculatedColumns(childElem, rset);
            }
            parentElem.addContent((Content)childElem);
        }
        if (sum != null) {
            for (Map.Entry entry : sum.entrySet()) {
                XMLUtils.addAttributeElement(parentElem, "tot" + (String)entry.getKey(), entry.getValue());
            }
        }
        return parentElem;
    }

    public static Element buildXMLFromResultSet(String parentName, String childName, ResultSet rset) throws Exception {
        return XMLUtils.buildXMLFromResultSet(parentName, childName, rset, null);
    }

    public static void cleanDocument(Document doc) throws Exception {
        XMLUtils.cleanElement(doc.getRootElement());
    }

    public static void cleanElement(Element el) throws Exception {
        List children = el.getChildren();
        if (children.size() > 0) {
            List content = el.getContent();
            Iterator ite = content.iterator();
            while (ite.hasNext()) {
                Content c = (Content)ite.next();
                if (!(c instanceof Element)) {
                    ite.remove();
                    continue;
                }
                XMLUtils.cleanElement((Element)c);
            }
        }
    }

    public static String documentToString(Document doc) throws Exception {
        return XMLUtils.documentToString(doc, "ISO-8859-1");
    }

    public static String documentToString(Document doc, String charset) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(512);
        XMLUtils.writeToStream(doc, (OutputStream)bout, charset);
        return bout.toString(charset);
    }

    public static String elementToString(Element element) throws Exception {
        return XMLUtils.elementToString(element, "ISO-8859-1");
    }

    public static String elementToString(Element element, String charset) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(512);
        XMLUtils.writeToStream(element, (OutputStream)bout, charset);
        return bout.toString(charset);
    }

    public static BigDecimal getAttributeAsBigDecimal(Element elem, String attName) {
        String valueAsString;
        Attribute att = elem.getAttribute(attName);
        BigDecimal result = null;
        if (att != null && (valueAsString = StringUtils.getEmptyAsNull(att.getValue())) != null) {
            try {
                result = StringUtils.convertToBigDecimal(valueAsString);
            }
            catch (NumberFormatException e) {
                IllegalArgumentException erro = new IllegalArgumentException("Atributo '" + attName + "' n\u00e3o \u00e9 um n\u00famero v\u00e1lido!");
                erro.initCause(e);
                throw erro;
            }
        }
        return result;
    }

    public static boolean getAttributeAsBoolean(Element elem, String attName) {
        Attribute att = elem.getAttribute(attName);
        boolean result = false;
        if (att != null) {
            result = Boolean.valueOf(att.getValue());
        }
        return result;
    }

    public static String getAttributeAsString(Element elem, String attName) {
        return XMLUtils.getAttributeAsString(elem, attName, false);
    }

    public static String getAttributeAsString(Element elem, String attName, boolean asIs) {
        Attribute att = elem.getAttribute(attName);
        String result = null;
        if (att != null) {
            result = att.getValue();
            if (!asIs) {
                result = result == null || result.trim().length() == 0 ? null : result.trim();
            }
        }
        return result;
    }

    public static Timestamp getAttributeAsTimestamp(Element elem, String attName) {
        String valueAsString;
        Attribute att = elem.getAttribute(attName);
        Timestamp result = null;
        if (att != null && (valueAsString = StringUtils.getEmptyAsNull(att.getValue())) != null) {
            result = TimeUtils.buildTimestamp(valueAsString);
        }
        return result;
    }

    public static <T extends Enum<T>> T getAttributeAsEnum(Element elem, String attName, Class<T> enumType) {
        String valueAsString;
        Attribute att = elem.getAttribute(attName);
        T result = null;
        if (att != null && (valueAsString = StringUtils.getEmptyAsNull(att.getValue())) != null) {
            result = Enum.valueOf(enumType, valueAsString);
        }
        return result;
    }

    public static BigDecimal getContentAsBigDecimal(Element sourceElement) {
        if (sourceElement == null) {
            return null;
        }
        String strContent = sourceElement.getText();
        if (StringUtils.getEmptyAsNull(strContent) == null) {
            return null;
        }
        try {
            return StringUtils.convertToBigDecimal(strContent);
        }
        catch (NumberFormatException e) {
            IllegalArgumentException erro = new IllegalArgumentException("Elemento '" + sourceElement.getName() + "' n\u00e3o \u00e9 um n\u00famero v\u00e1lido!");
            erro.initCause(e);
            throw erro;
        }
    }

    public static Boolean getContentAsBoolean(Element sourceElement) {
        if (sourceElement == null) {
            return Boolean.FALSE;
        }
        String strContent = sourceElement.getText();
        if (StringUtils.getEmptyAsNull(strContent) == null) {
            return Boolean.FALSE;
        }
        return Boolean.valueOf(strContent);
    }

    public static String getContentAsString(Element sourceElement) {
        if (sourceElement == null) {
            return null;
        }
        return sourceElement.getText();
    }

    public static Timestamp getContentAsTimeStamp(Element sourceElement) {
        String strContent = sourceElement.getText();
        if (StringUtils.getEmptyAsNull(strContent) == null) {
            return null;
        }
        return TimeUtils.buildTimestamp(strContent);
    }

    public static <T extends Enum<T>> T getContentAsEnum(Element sourceElement, Class<T> enumType) {
        String strContent = sourceElement.getText();
        if (StringUtils.getEmptyAsNull(strContent) == null) {
            return null;
        }
        return Enum.valueOf(enumType, strContent);
    }

    public static BigDecimal getContentChildAsBigDecimal(Element source, String elementName) {
        Element elementChild;
        if (source != null && (elementChild = source.getChild(elementName)) != null) {
            return XMLUtils.getContentAsBigDecimal(elementChild);
        }
        return null;
    }

    public static Boolean getContentChildAsBoolean(Element source, String elementName) {
        Element elementChild;
        if (source != null && (elementChild = source.getChild(elementName)) != null) {
            return XMLUtils.getContentAsBoolean(elementChild);
        }
        return Boolean.FALSE;
    }

    public static String getContentChildAsString(Element source, String elementName) {
        Element elementChild;
        if (source != null && (elementChild = source.getChild(elementName)) != null) {
            String value = XMLUtils.getContentAsString(elementChild);
            return value != null && value.length() == 0 ? null : value;
        }
        return null;
    }

    public static Timestamp getContentChildAsTimeStamp(Element source, String elementName) {
        Element elementChild;
        if (source != null && (elementChild = source.getChild(elementName)) != null) {
            return XMLUtils.getContentAsTimeStamp(elementChild);
        }
        return null;
    }

    public static <T extends Enum<T>> T getContentChildAsEnum(Element source, String elementName, Class<T> enumType) {
        Element elementChild;
        if (source != null && (elementChild = source.getChild(elementName)) != null) {
            return XMLUtils.getContentAsEnum(elementChild, enumType);
        }
        return null;
    }

    public static BigDecimal getRequiredAttributeAsBigDecimal(Element elem, String attName) throws Exception {
        BigDecimal attValue = XMLUtils.getAttributeAsBigDecimal(elem, attName);
        if (attValue == null) {
            throw new IllegalArgumentException("\u00c9 necess\u00e1rio informar o atributo '" + attName + "'");
        }
        return attValue;
    }

    public static String getRequiredAttributeAsString(Element elem, String attName) throws Exception {
        String attValue = StringUtils.getEmptyAsNull(XMLUtils.getAttributeAsString(elem, attName));
        if (attValue == null) {
            throw new IllegalArgumentException("\u00c9 necess\u00e1rio informar o atributo '" + attName + "'");
        }
        return attValue;
    }

    public static Timestamp getRequiredAttributeAsTimestamp(Element elem, String attName) throws Exception {
        Timestamp attValue = XMLUtils.getAttributeAsTimestamp(elem, attName);
        if (attValue == null) {
            throw new IllegalArgumentException("\u00c9 necess\u00e1rio informar o atributo '" + attName + "'");
        }
        return attValue;
    }

    public static <T extends Enum<T>> T getRequiredAttributeAsEnum(Element elem, String attName, Class<T> enumType) {
        T attValue = XMLUtils.getAttributeAsEnum(elem, attName, enumType);
        if (attValue == null) {
            throw new IllegalArgumentException("\u00c9 necess\u00e1rio informar o atributo '" + attName + "'");
        }
        return attValue;
    }

    public static Element getRequiredChild(Element source, String elementName, String nameSpace) throws Exception {
        Element returnedElement = nameSpace == null ? source.getChild(elementName) : source.getChild(elementName, source.getNamespace(nameSpace));
        if (returnedElement == null) {
            throw new IllegalArgumentException("Erro interno: Informe o elemento '" + elementName + "'.");
        }
        return returnedElement;
    }

    public static Element getRequiredChild(Element source, String elementName) throws Exception {
        return XMLUtils.getRequiredChild(source, elementName, null);
    }

    public static BigDecimal getRequiredContentAsBigDecimal(Element sourceElement) {
        if (sourceElement == null) {
            throw new IllegalArgumentException("\u00c9 necess\u00e1rio informar o sourceElement.");
        }
        BigDecimal value = XMLUtils.getContentAsBigDecimal(sourceElement);
        if (value == null) {
            throw new IllegalArgumentException("\u00c9 necess\u00e1rio informar o conte\u00fado do elemento '" + sourceElement.getName() + "'.");
        }
        return value;
    }

    public static String getRequiredContentAsString(Element sourceElement) {
        if (sourceElement == null) {
            throw new IllegalArgumentException("\u00c9 necess\u00e1rio informar o sourceElement.");
        }
        String value = XMLUtils.getContentAsString(sourceElement);
        if (value == null) {
            throw new IllegalArgumentException("\u00c9 necess\u00e1rio informar o conte\u00fado do elemento '" + sourceElement.getName() + "'.");
        }
        return value;
    }

    public static Timestamp getRequiredContentAsTimestamp(Element sourceElement) {
        if (sourceElement == null) {
            throw new IllegalArgumentException("\u00c9 necess\u00e1rio informar o sourceElement.");
        }
        Timestamp value = XMLUtils.getContentAsTimeStamp(sourceElement);
        if (value == null) {
            throw new IllegalArgumentException("\u00c9 necess\u00e1rio informar o conte\u00fado do elemento '" + sourceElement.getName() + "'.");
        }
        return value;
    }

    public static BigDecimal getRequiredContentChildAsBigDecimal(Element source, String elementName) {
        Element elementChild;
        if (source != null && (elementChild = source.getChild(elementName)) != null) {
            return XMLUtils.getRequiredContentAsBigDecimal(elementChild);
        }
        return null;
    }

    public static String getRequiredContentChildAsString(Element source, String elementName) {
        Element elementChild;
        if (source != null && (elementChild = source.getChild(elementName)) != null) {
            return XMLUtils.getRequiredContentAsString(elementChild);
        }
        return null;
    }

    public static Timestamp getRequiredContentChildAsTimeStamp(Element source, String elementName) {
        Element elementChild;
        if (source != null && (elementChild = source.getChild(elementName)) != null) {
            return XMLUtils.getRequiredContentAsTimestamp(elementChild);
        }
        return null;
    }

    public static String getStringOrEmpty(Object obj) {
        return obj != null ? obj.toString() : "";
    }

    public static void iterateOnChildren(String childName, Element base, ChildIterator cite) throws Exception {
        for (Element child : base.getChildren()) {
            if (!child.getName().equals(childName)) continue;
            cite.nextChild(child);
        }
    }

    public static void printFromDebug(Element el) {
        XMLOutputter xout = new XMLOutputter();
        try {
            xout.output(el, (OutputStream)System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Element removeChildIgnoringNameSpace(Element base, String childName) {
        Iterator ite = base.getChildren().iterator();
        while (ite.hasNext()) {
            Element child = (Element)ite.next();
            if (!child.getName().equals(childName)) continue;
            ite.remove();
            return child;
        }
        return null;
    }

    public static void setAttibuteIfNotEmpty(Element elem, String name, String value) {
        if (value == null || "".equals(value)) {
            return;
        }
        XMLUtils.setAttibuteValue(elem, name, value);
    }

    public static void setAttibuteValue(Element elem, String name, Object value) {
        elem.setAttribute(name, value != null ? value.toString() : "");
    }

    public static void setText(Element elem, Object value) {
        elem.setText(value == null ? "" : value.toString());
    }

    public static void writeToStream(Document doc, OutputStream out) throws Exception {
        XMLUtils.writeToStream(doc, out, "ISO-8859-1");
    }

    public static void writeToStream(Document doc, OutputStream out, String charset) throws Exception {
        XMLOutputter outter = new XMLOutputter();
        Format format = Format.getRawFormat();
        format.setEncoding(charset);
        outter.setFormat(format);
        outter.output(doc, out);
        out.flush();
    }

    public static String getXMLString(Element element, String encode) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLUtils.writeToStream(element, (OutputStream)out, encode);
        return out.toString(encode);
    }

    public static void writeToStream(Element element, OutputStream out) throws Exception {
        XMLUtils.writeToStream(element, out, "ISO-8859-1");
    }

    public static void writeToStream(Element element, OutputStream out, String charset) throws Exception {
        XMLOutputter outter = new XMLOutputter();
        Format format = Format.getRawFormat();
        format.setEncoding(charset);
        outter.setFormat(format);
        outter.output(element, out);
        out.flush();
    }

    public static Collection<BigDecimal> getChildrenContentAsBigDecimalCollection(Element root, String elementName) {
        List children = root.getChildren(elementName);
        ArrayList<BigDecimal> bigDecimalColl = new ArrayList<BigDecimal>();
        for (Element child : children) {
            String text = child.getText();
            try {
                BigDecimal numero = new BigDecimal(text);
                bigDecimalColl.add(numero);
            }
            catch (NumberFormatException ignored) {}
        }
        return bigDecimalColl;
    }

    public static void setNamespaceRecursively(Element rootElement, Namespace namespace) {
        List children = rootElement.getChildren();
        if ("Signature".equals(rootElement.getName())) {
            return;
        }
        for (Element child : children) {
            XMLUtils.setNamespaceRecursively(child, namespace);
        }
        rootElement.setNamespace(namespace);
    }

    private static class XPathToken {
        String name;
        boolean anyLevel;

        private XPathToken() {
        }
    }

    public static class SimpleXPath {
        List tokens;
        boolean singleNode;
        int lastToken;
        Filter filter;

        public static SimpleXPath build(String path) {
            return SimpleXPath.build(path, null);
        }

        public static SimpleXPath build(String path, Filter filter) {
            SimpleXPath xp = new SimpleXPath();
            xp.filter = filter;
            xp.tokens = new ArrayList();
            String[] v = path.split("/");
            boolean nextIsAnyLevel = false;
            for (int i = 0; i < v.length; ++i) {
                String token = v[i].trim();
                if (token.equals(".")) continue;
                if (token.length() == 0) {
                    nextIsAnyLevel = true;
                    continue;
                }
                XPathToken tk = new XPathToken();
                tk.anyLevel = nextIsAnyLevel;
                tk.name = token;
                nextIsAnyLevel = false;
                xp.tokens.add(tk);
            }
            xp.lastToken = xp.tokens.size() - 1;
            return xp;
        }

        public static String getNodeText(Element base, String xPath) {
            return SimpleXPath.getNodeText(base, xPath, null);
        }

        public static String getNodeText(Element base, String xPath, String defValue) {
            SimpleXPath xp = SimpleXPath.build(xPath);
            Element e = xp.selectSingleNode(base);
            return e == null ? defValue : e.getTextTrim();
        }

        public Element selectSingleNode(Element base) {
            this.singleNode = true;
            return (Element)this.search(base, 0);
        }

        public Collection<Element> selectNodes(Element base) {
            this.singleNode = false;
            return (Collection)this.search(base, 0);
        }

        public static Collection<Element> selectNodes(Element base, String xPath) {
            SimpleXPath xp = SimpleXPath.build(xPath);
            return xp.selectNodes(base);
        }

        public static Collection<Element> selectNodes(Element base, String xPath, Filter filter) {
            SimpleXPath xp = SimpleXPath.build(xPath, filter);
            return xp.selectNodes(base);
        }

        public static Element selectSingleNode(Element base, String xPath) {
            SimpleXPath xp = SimpleXPath.build(xPath);
            return xp.selectSingleNode(base);
        }

        public static Element selectSingleNode(Element base, String xPath, Filter filter) {
            SimpleXPath xp = SimpleXPath.build(xPath, filter);
            return xp.selectSingleNode(base);
        }

        private Object search(Element base, int currentToken) {
            XPathToken curToken = (XPathToken)this.tokens.get(currentToken);
            List children = base.getChildren();
            ArrayList<Element> selectedNodes = null;
            if (!this.singleNode) {
                selectedNodes = new ArrayList<Element>();
            }
            for (Element child : children) {
                if (!curToken.name.equals("*") && !curToken.name.equals(child.getName()) || this.filter != null && !this.filter.accept(child)) continue;
                int nextToken = currentToken + 1;
                if (nextToken > this.lastToken) {
                    if (this.singleNode) {
                        return child;
                    }
                    selectedNodes.add(child);
                    continue;
                }
                Object result = this.search(child, nextToken);
                if (result == null) continue;
                if (this.singleNode) {
                    return result;
                }
                selectedNodes.addAll((Collection)result);
            }
            if (curToken.anyLevel) {
                for (Element child : children) {
                    Object result = this.search(child, currentToken);
                    if (result == null) continue;
                    if (this.singleNode) {
                        return result;
                    }
                    selectedNodes.addAll((Collection)result);
                }
            }
            if (this.singleNode) {
                return null;
            }
            return selectedNodes;
        }

        public static interface Filter {
            public boolean accept(Element var1);
        }
    }

    public static interface RowBuilder {
        public boolean acceptColumn(String var1);

        public void addCalculatedColumns(Element var1, ResultSet var2) throws Exception;

        public Object formatColumn(Object var1, String var2);

        public String[] getSumColumns();
    }

    public static interface ChildIterator {
        public void nextChild(Element var1) throws Exception;
    }
}

