/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

public class ValidadorCpfCnpj {
    private String message;
    private String number;
    private int typenumber;
    public static final int CPF = 1;
    public static final int CNPJ = 2;

    public ValidadorCpfCnpj() {
    }

    public ValidadorCpfCnpj(String value) {
        this();
        this.number = value;
        if (this.number != null) {
            this.typenumber = this.number.length() == 14 ? 2 : 1;
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public void setTypenumber(int type) {
        this.typenumber = type;
    }

    public int getTypenumber() {
        return this.typenumber;
    }

    public boolean isValid() {
        int soma = 0;
        this.message = "";
        try {
            Long.parseLong(this.number);
        }
        catch (Exception e) {
            this.message = "Somente numeros s\u00e3o permitidos";
            return false;
        }
        if (this.typenumber == 1) {
            if (this.number.length() == 11) {
                int i;
                for (i = 0; i < 9; ++i) {
                    soma += (10 - i) * (this.number.charAt(i) - 48);
                }
                if ((soma = 11 - soma % 11) > 9) {
                    soma = 0;
                }
                if (soma == this.number.charAt(9) - 48) {
                    soma = 0;
                    for (i = 0; i < 10; ++i) {
                        soma += (11 - i) * (this.number.charAt(i) - 48);
                    }
                    if ((soma = 11 - soma % 11) > 9) {
                        soma = 0;
                    }
                    if (soma == this.number.charAt(10) - 48) {
                        this.message = "CPF V\u00e1lido";
                        return true;
                    }
                }
            }
            this.message = "CPF Inv\u00e1lido";
        } else if (this.typenumber == 2) {
            if (this.number.length() == 14) {
                int i;
                int j = 5;
                for (i = 0; i < 12; ++i) {
                    soma += j-- * (this.number.charAt(i) - 48);
                    if (j >= 2) continue;
                    j = 9;
                }
                if ((soma = 11 - soma % 11) > 9) {
                    soma = 0;
                }
                if (soma == this.number.charAt(12) - 48) {
                    soma = 0;
                    j = 6;
                    for (i = 0; i < 13; ++i) {
                        soma += j-- * (this.number.charAt(i) - 48);
                        if (j >= 2) continue;
                        j = 9;
                    }
                    if ((soma = 11 - soma % 11) > 9) {
                        soma = 0;
                    }
                    if (soma == this.number.charAt(13) - 48) {
                        this.message = "CNPJ V\u00e1lido";
                        return true;
                    }
                }
            }
            this.message = "CNPJ Inv\u00e1lido";
        }
        return false;
    }

    public static void main(String[] args) {
        ValidadorCpfCnpj val = new ValidadorCpfCnpj();
        val.setNumber("05501072000137");
        val.setTypenumber(2);
        System.out.println(val.isValid());
    }
}

