/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

public class UrlUtils {
    public static Map<String, String> parseUrlParameters(String url) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (url != null) {
            String[] pairs = url.split("&");
            for (int i = 0; i < pairs.length; ++i) {
                String[] parts = pairs[i].split("=");
                params.put(parts[0], UrlUtils.urlDecode(parts[1]));
            }
        }
        return params;
    }

    private static String urlDecode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error in urlDecode.", e);
        }
    }

    public static String updateURLParameters(String url, Map<String, String> newAttribs) {
        if (url == null) {
            return null;
        }
        String[] parts = url.split("\\?");
        Map<String, String> attribs = UrlUtils.parseUrlParameters(parts[1]);
        attribs.putAll(newAttribs);
        StringBuffer urlBuf = new StringBuffer();
        urlBuf.append(parts[0]);
        boolean isFirst = true;
        for (String key : attribs.keySet()) {
            urlBuf.append(isFirst ? "?" : "&").append(key).append("=").append(attribs.get(key));
            isFirst = false;
        }
        return urlBuf.toString();
    }
}

