/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import br.com.sankhya.MethodInfo.MethodInfo;
import com.sankhya.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class TimeUtils {
    private static Map<Integer, int[]> weekendJump = new HashMap<Integer, int[]>();
    private static long zeroDate;
    public static final int MINUTES_PER_DAY = 1440;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int MILLISECONDS_PER_DAY = 86400000;
    public static final int MILLISECONDS_PER_SECONDS = 1000;

    public static long add(long timestamp, int amount, int field) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(timestamp);
        calendar.add(field, amount);
        return calendar.getTimeInMillis();
    }

    public static long set(long timestamp, int value, int field) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(timestamp);
        calendar.set(field, value);
        return calendar.getTimeInMillis();
    }

    public static long addWorkingDays(long time, int days) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(time);
        int i = 0;
        while (i < days) {
            ((Calendar)c).add(5, 1);
            int day = c.get(7);
            if (day == 7 || day == 1) continue;
            ++i;
        }
        return c.getTimeInMillis();
    }

    public static long clear(long timestamp, int field) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(timestamp);
        calendar.clear(field);
        return calendar.getTimeInMillis();
    }

    public static Timestamp bigDecimal2Timestamp(BigDecimal time) throws Exception {
        String strOrigem = time.toString();
        strOrigem = StringUtils.padl(strOrigem, 6, '0');
        StringBuffer strHora = new StringBuffer();
        strHora.append(strOrigem.substring(0, 2));
        strHora.append(":");
        strHora.append(strOrigem.substring(2, 4));
        strHora.append(":");
        strHora.append(strOrigem.substring(4, 6));
        return TimeUtils.toTimestamp(strHora.toString(), "HH:mm:ss");
    }

    public static Timestamp buildPrintableTimestamp(long time, final String format) {
        return new Timestamp(time){

            @Override
            public String toString() {
                SimpleDateFormat dfm = new SimpleDateFormat(format);
                return dfm.format(this);
            }
        };
    }

    public static Timestamp buildTimestamp(String text) {
        GregorianCalendar c;
        block12: {
            block11: {
                String time;
                if ((text = StringUtils.getEmptyAsNull(text)) == null) {
                    return null;
                }
                int dateSeparatorCount = StringUtils.countChars(text, '/');
                c = new GregorianCalendar();
                int currentMillenium = c.get(1) / 100 * 100;
                c.clear();
                int dateTimeSeparator = text.indexOf(32);
                if (dateTimeSeparator == -1) {
                    dateTimeSeparator = text.length();
                }
                if (dateSeparatorCount == 0) break block11;
                if (dateSeparatorCount != 2) {
                    throw new IllegalArgumentException("Data inv\u00e1lida: " + text);
                }
                String date = text.substring(0, dateTimeSeparator).trim();
                if (StringUtils.countChars(date, '/') != 2) {
                    throw new IllegalArgumentException("Data inv\u00e1lida: " + text);
                }
                int[][] dateComponents = new int[][]{{5, 0}, {2, -1}, {1, 0}};
                int componentIndex = 0;
                StringTokenizer tokenizer = new StringTokenizer(date, "/");
                while (tokenizer.hasMoreTokens()) {
                    int val = Integer.parseInt(tokenizer.nextToken().trim());
                    c.set(dateComponents[componentIndex][0], val + dateComponents[componentIndex++][1]);
                }
                if (c.get(1) < 1000) {
                    ((Calendar)c).add(1, currentMillenium);
                }
                String string = time = dateTimeSeparator < text.length() ? text.substring(dateTimeSeparator).trim() : "";
                if (time.length() <= 0) break block12;
                int timeSeparatorCount = StringUtils.countChars(time, ':');
                if (timeSeparatorCount == 0) {
                    time = TimeUtils.insertTimeSeparator(time);
                }
                if (timeSeparatorCount > 2) {
                    throw new IllegalArgumentException("Hora inv\u00e1lida: " + text);
                }
                tokenizer = new StringTokenizer(time, ":");
                int[] timeComponents = new int[]{11, 12, 13};
                componentIndex = 0;
                while (tokenizer.hasMoreTokens()) {
                    c.set(timeComponents[componentIndex++], Integer.parseInt(tokenizer.nextToken().trim()));
                }
                break block12;
            }
            int timeSeparatorCount = StringUtils.countChars(text, ':');
            if (timeSeparatorCount > 2) {
                throw new IllegalArgumentException("Hora inv\u00e1lida: " + text);
            }
            StringTokenizer tokenizer = new StringTokenizer(text, ":");
            int[] timeComponents = new int[]{11, 12, 13};
            int componentIndex = 0;
            while (tokenizer.hasMoreTokens()) {
                c.set(timeComponents[componentIndex++], Integer.parseInt(tokenizer.nextToken().trim()));
            }
        }
        return new Timestamp(c.getTimeInMillis());
    }

    public static long clearDate(long datetime) {
        long date = TimeUtils.clearTime(datetime);
        return datetime - date;
    }

    public static Timestamp clearTime(Timestamp timestamp) {
        return new Timestamp(TimeUtils.clearTime(timestamp.getTime()));
    }

    public static long clearTime(long timestamp) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(timestamp);
        TimeUtils.clearTime(calendar);
        return calendar.getTime().getTime();
    }

    public static void clearTime(Calendar calendar) {
        calendar.clear(11);
        calendar.clear(10);
        calendar.clear(12);
        calendar.clear(13);
        calendar.clear(14);
        calendar.clear(9);
    }

    public static int compareDates(Calendar c1, Calendar c2) {
        long l1 = c1.get(1) * 10000 + c1.get(2) * 100 + c1.get(5);
        long l2 = c2.get(1) * 10000 + c2.get(2) * 100 + c2.get(5);
        return (int)(l1 - l2);
    }

    public static int compareOnlyDates(Timestamp t1, Timestamp t2) {
        if (t1 == null) {
            if (t2 == null) {
                return 0;
            }
            return -1;
        }
        if (t2 == null) {
            return 1;
        }
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(t1.getTime());
        long l1 = c.get(1) * 10000 + c.get(2) * 100 + c.get(5);
        c.setTimeInMillis(t2.getTime());
        long l2 = c.get(1) * 10000 + c.get(2) * 100 + c.get(5);
        return (int)(l1 - l2);
    }

    public static Timestamp concatDateAndTime(Timestamp date, Timestamp time) throws Exception {
        SimpleDateFormat dfDate = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat dfTime = new SimpleDateFormat("HH:mm:ss");
        return TimeUtils.toTimestamp(dfDate.format(date).concat(" ").concat(dfTime.format(time)), "dd/MM/yyyy HH:mm:ss");
    }

    @MethodInfo(name="", description="Retorna o mes por extenso.", arguments={""}, category="Outra")
    public static String mesext(Timestamp date) {
        return new SimpleDateFormat("MMMMMMMMMM").format(date);
    }

    public static String dataPorExtenso(Object data) {
        if (data == null) {
            return "";
        }
        return new SimpleDateFormat("dd 'de' MMMMMMMMMM 'de' yyyy").format(data);
    }

    public static Integer dayOfWeek(Timestamp data) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(data.getTime());
        return new Integer(cal.get(7));
    }

    public static String formataDDMMYY(Object data) {
        SimpleDateFormat frmData = new SimpleDateFormat("dd/MM/yy");
        return data != null ? frmData.format(data) : "  /  /  ";
    }

    public static String formataDDMMYYYY(Object data) {
        SimpleDateFormat frmData = new SimpleDateFormat("dd/MM/yyyy");
        return data != null ? frmData.format(data) : "  /  /    ";
    }

    public static long getDayEnd(long time) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(time);
        c.set(11, ((Calendar)c).getActualMaximum(11));
        c.set(10, ((Calendar)c).getActualMaximum(10));
        c.set(12, ((Calendar)c).getActualMaximum(12));
        c.set(13, ((Calendar)c).getActualMaximum(13));
        c.set(14, ((Calendar)c).getActualMaximum(14));
        c.set(9, ((Calendar)c).getActualMaximum(9));
        return c.getTimeInMillis();
    }

    public static long getDayStart(long time) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(time);
        c.set(11, ((Calendar)c).getActualMinimum(11));
        c.set(10, ((Calendar)c).getActualMinimum(10));
        c.set(12, ((Calendar)c).getActualMinimum(12));
        c.set(13, ((Calendar)c).getActualMinimum(13));
        c.set(14, ((Calendar)c).getActualMinimum(14));
        c.set(9, ((Calendar)c).getActualMinimum(9));
        return c.getTimeInMillis();
    }

    public static int getMaximum(Timestamp time, int field) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(time.getTime());
        return ((Calendar)c).getActualMaximum(field);
    }

    public static int getDifference(Timestamp t1, Timestamp t2) {
        return TimeUtils.getDifference(t1, t2, true);
    }

    public static int getDifference(Timestamp t1, Timestamp t2, boolean unsigned) {
        long l2;
        long l1 = t1.getTime();
        int result = (int)(l1 / 86400000L - (l2 = t2.getTime()) / 86400000L);
        if (result < 0 && unsigned) {
            result *= -1;
        }
        return result;
    }

    public static long getDifferenceInMinutes(Timestamp t1, Timestamp t2, boolean unsigned) {
        long l1 = t1.getTime();
        long l2 = t2.getTime();
        int result = (int)(TimeUtils.timestamp2Minutes(l1) - TimeUtils.timestamp2Minutes(l2));
        if (result < 0 && unsigned) {
            result *= -1;
        }
        return result;
    }

    public static long getDifferenceInMinutes(Timestamp t1, Timestamp t2) {
        return TimeUtils.getDifferenceInMinutes(t1, t2, true);
    }

    public static long getDifferenceInMonths(Timestamp t1, Timestamp t2) {
        GregorianCalendar c1 = new GregorianCalendar();
        GregorianCalendar c2 = new GregorianCalendar();
        c1.setTime(t1);
        c2.setTime(t2);
        c1.setTimeInMillis(TimeUtils.clearTime(c1.getTimeInMillis()));
        c2.setTimeInMillis(TimeUtils.clearTime(c2.getTimeInMillis()));
        c1.set(5, 1);
        c2.set(5, 1);
        int meses = 0;
        while (c1.getTimeInMillis() != c2.getTimeInMillis()) {
            ++meses;
            if (c1.compareTo(c2) < 0) {
                ((Calendar)c1).add(2, 1);
                continue;
            }
            ((Calendar)c1).add(2, -1);
        }
        return meses;
    }

    public static Date copyValue(Date dtFrom, Date dtTo, int field) {
        GregorianCalendar c1 = new GregorianCalendar();
        GregorianCalendar c2 = new GregorianCalendar();
        c1.setTime(dtTo);
        c2.setTime(dtFrom);
        c1.set(field, c2.get(field));
        return c1.getTime();
    }

    public static String getDisplayableTime(int timeWithMinutes) {
        return TimeUtils.getDisplayableTime(new BigDecimal(timeWithMinutes));
    }

    public static String getDisplayableTime(BigDecimal timeWithMinutes) {
        if (timeWithMinutes == null) {
            return "";
        }
        boolean negative = false;
        if (timeWithMinutes.intValue() < 0) {
            negative = true;
            timeWithMinutes = timeWithMinutes.multiply(new BigDecimal(-1));
        }
        String strTimeWithMinutes = String.valueOf(timeWithMinutes.intValue());
        int minutesStart = Math.max(strTimeWithMinutes.length() - 2, 0);
        String timeToken = strTimeWithMinutes.substring(0, minutesStart).trim();
        String minuteToken = strTimeWithMinutes.substring(minutesStart).trim();
        Integer time = new Integer(0);
        Integer minute = new Integer(0);
        String result = null;
        if (timeToken != null && timeToken.length() > 0) {
            if (timeToken.length() == 1 && timeToken.equals("-")) {
                timeToken = null;
            }
            if (timeToken != null) {
                time = new Integer(timeToken);
            }
        }
        if (minuteToken != null && minuteToken.length() > 0) {
            minute = new Integer(minuteToken);
        }
        StringBuffer buf = new StringBuffer();
        buf.append(time);
        buf.append(":");
        buf.append(StringUtils.stringZero(minute, 2));
        result = buf.length() < 5 ? StringUtils.padl(buf.toString(), 5, '0') : buf.toString();
        if (negative) {
            result = "-" + result;
        }
        return result;
    }

    public static BigDecimal getHoraDecimal(Timestamp data) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(data.getTime());
        String hora = String.valueOf(cal.get(11));
        String minutos = String.valueOf(cal.get(12));
        if (minutos.length() == 1) {
            minutos = "0" + minutos;
        }
        return new BigDecimal(hora + minutos);
    }

    public static long getMonthEnd(long time) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(time);
        c.set(5, ((Calendar)c).getActualMaximum(5));
        c.clear(11);
        c.clear(10);
        c.clear(12);
        c.clear(13);
        c.clear(14);
        c.clear(9);
        return c.getTimeInMillis();
    }

    public static long getMonthStart(long time) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(time);
        c.set(5, ((Calendar)c).getActualMinimum(5));
        c.clear(11);
        c.clear(10);
        c.clear(12);
        c.clear(13);
        c.clear(14);
        c.clear(9);
        return c.getTimeInMillis();
    }

    public static String getNow(String formatPattern) {
        SimpleDateFormat df = new SimpleDateFormat(formatPattern);
        return df.format(new Date());
    }

    public static Timestamp getNow() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static int getTimeInMinutes(Timestamp t1) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(t1);
        return c.get(11) * 60 + c.get(12);
    }

    public static long getToday() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        calendar.clear(11);
        calendar.clear(10);
        calendar.clear(12);
        calendar.clear(13);
        calendar.clear(14);
        calendar.clear(9);
        return calendar.getTime().getTime();
    }

    public static long getToday(int[] clearFields) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(System.currentTimeMillis());
        for (int i = 0; i < clearFields.length; ++i) {
            calendar.clear(clearFields[i]);
        }
        return calendar.getTimeInMillis();
    }

    public static Timestamp getValueOrNow(Timestamp value) {
        Timestamp result = value == null ? new Timestamp(System.currentTimeMillis()) : value;
        return result;
    }

    public static int getWeekOfYear(Date d) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTimeInMillis(d.getTime());
        return calendar.get(3);
    }

    public static BigDecimal getYearMonth(Timestamp time) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(time.getTime());
        int year = c.get(1);
        int mounth = c.get(2) + 1;
        return new BigDecimal(year * 100 + mounth);
    }

    public static long getZeroDate() {
        return zeroDate;
    }

    public static Timestamp getTimeOrZero(Timestamp time) {
        if (time == null) {
            return new Timestamp(zeroDate);
        }
        return time;
    }

    public static boolean isValidTime(BigDecimal timeWithMinutes) {
        int time = 0;
        int minute = 0;
        if (timeWithMinutes == null) {
            return true;
        }
        String strTimeWithMinutes = String.valueOf(timeWithMinutes.intValue());
        int minutesStart = Math.max(strTimeWithMinutes.length() - 2, 0);
        try {
            String timeToken = strTimeWithMinutes.substring(0, minutesStart).trim();
            String minuteToken = strTimeWithMinutes.substring(minutesStart).trim();
            time = 0;
            minute = 0;
            if (timeToken != null && timeToken.length() > 0) {
                time = Integer.parseInt(timeToken);
            }
            if (minuteToken != null && minuteToken.length() > 0) {
                minute = Integer.parseInt(minuteToken);
            }
            return time >= 0 && minute >= 0 && minute <= 59;
        }
        catch (RuntimeException e) {
            System.out.println("Debug: strTimeWithMinutes=" + strTimeWithMinutes);
            throw e;
        }
    }

    public static BigDecimal minutes2Time(int minutes) {
        return TimeUtils.minutes2Time(new BigDecimal(minutes));
    }

    public static BigDecimal minutes2Time(BigDecimal minutes) {
        int time = 0;
        int minute = 0;
        if (minutes == null) {
            return new BigDecimal(0);
        }
        time = minutes.intValue() / 60;
        minute = minutes.intValue() % 60;
        return new BigDecimal(time * 100 + minute);
    }

    public static long minutes2Timestamp(long minutes) {
        return minutes * 60L * 1000L;
    }

    public static BigDecimal time2Minutes(int timeWithMinutes) {
        return TimeUtils.time2Minutes(new BigDecimal(timeWithMinutes));
    }

    public static BigDecimal time2Minutes(BigDecimal timeWithMinutes) {
        int time = 0;
        int minute = 0;
        if (timeWithMinutes == null) {
            return new BigDecimal(0);
        }
        String strTimeWithMinutes = String.valueOf(timeWithMinutes.intValue());
        int minutesStart = Math.max(strTimeWithMinutes.length() - 2, 0);
        try {
            String timeToken = strTimeWithMinutes.substring(0, minutesStart).trim();
            String minuteToken = strTimeWithMinutes.substring(minutesStart).trim();
            time = 0;
            minute = 0;
            if (timeToken != null && timeToken.length() > 0) {
                time = Integer.parseInt(timeToken);
            }
            if (minuteToken != null && minuteToken.length() > 0) {
                minute = Integer.parseInt(minuteToken);
            }
        }
        catch (RuntimeException e) {
            System.out.println("Debug: strTimeWithMinutes=" + strTimeWithMinutes);
            throw e;
        }
        return new BigDecimal(time * 60 + minute);
    }

    public static BigDecimal timestamp2BigDecimal(Timestamp time) {
        SimpleDateFormat df = new SimpleDateFormat("HHmmss");
        String strTime = df.format(time);
        return new BigDecimal(Integer.parseInt(strTime));
    }

    public static long timestamp2Minutes(long timestamp) {
        return timestamp / 1000L / 60L;
    }

    public static String milisegundos2HHmmss(long timeMillis) throws Exception {
        SimpleDateFormat horasFormat = new SimpleDateFormat("HH:mm:ss");
        long time = timeMillis / 1000L;
        int seconds = (int)(time % 60L);
        int minutes = (int)(time % 3600L / 60L);
        int hours = (int)(time / 3600L);
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(13, seconds);
        cal.set(12, minutes);
        cal.set(11, hours);
        return horasFormat.format(cal.getTime());
    }

    public static long toDate(String s) throws Exception {
        return TimeUtils.toDate(s, "dd/MM/yyyy");
    }

    public static long toDate(String s, String pattern) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.parse(s).getTime();
    }

    public static BigDecimal toDecimalTime(String timeWithMinutes) {
        if ((timeWithMinutes = StringUtils.getEmptyAsNull(timeWithMinutes)) == null) {
            return null;
        }
        int timeSeparatorIndex = timeWithMinutes.indexOf(58);
        if (timeSeparatorIndex < 0) {
            throw new IllegalArgumentException("Formato de hora decimal inv\u00e1lido: " + timeWithMinutes);
        }
        int time = Integer.parseInt(timeWithMinutes.substring(0, timeSeparatorIndex)) * 100;
        int minutes = Integer.parseInt(timeWithMinutes.substring(timeSeparatorIndex + 1));
        return new BigDecimal(time + minutes);
    }

    public static Timestamp toTimestamp(String s) throws Exception {
        return new Timestamp(TimeUtils.toDate(s));
    }

    public static Timestamp toTimestamp(String s, String pattern) throws Exception {
        return new Timestamp(TimeUtils.toDate(s, pattern));
    }

    public static long weekendFoward(long time) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(time);
        int[] days = weekendJump.get(new Integer(c.get(7)));
        if (days != null) {
            ((Calendar)c).add(7, days[1]);
        }
        return c.getTimeInMillis();
    }

    public static long weekendReward(long time) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(time);
        int[] days = weekendJump.get(new Integer(c.get(7)));
        if (days != null) {
            ((Calendar)c).add(7, days[0]);
        }
        return c.getTimeInMillis();
    }

    private static String insertTimeSeparator(String hora) {
        int tam = hora.length();
        int cont = 1;
        StringBuffer result = new StringBuffer(hora);
        for (int i = tam; i > 1; --i) {
            if (cont == 2) {
                result.insert(i - 1, ':');
                cont = 1;
                continue;
            }
            ++cont;
        }
        return result.toString();
    }

    public static Timestamp buildData(int dia, int mes, int ano) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(ano, mes - 1, dia);
        TimeUtils.clearTime(calendar);
        return new Timestamp(calendar.getTimeInMillis());
    }

    static {
        weekendJump.put(new Integer(7), new int[]{-1, 2});
        weekendJump.put(new Integer(1), new int[]{-2, 1});
        try {
            SimpleDateFormat dtFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            zeroDate = dtFormat.parse("30/12/1899 00:00:00").getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static class Schedule {
        public static final int EVERY_DAY = 0;
        public static final int PER_DAY_OF_WEEK = 1;
        public static final int PER_DAY_OF_MONTH = 2;
        private List<Integer> minutesAtDay;
        private Map<Integer, Object> daysOfMonth;
        private Map<Integer, Object> daysOfWeek = new HashMap<Integer, Object>();
        private Map<Integer, Object> months;
        private int hours;
        private int minutes;
        private int type;

        public Schedule() {
            this.daysOfMonth = new HashMap<Integer, Object>();
            this.months = new HashMap<Integer, Object>();
            this.minutesAtDay = new ArrayList<Integer>();
        }

        public void addDayOfMonth(int dayOfMonth) {
            this.daysOfMonth.put(new Integer(dayOfMonth), null);
        }

        public void addDayOfWeek(int dayOfWeek) {
            this.daysOfWeek.put(new Integer(dayOfWeek), null);
        }

        public void addHourOfDay(int hourWithMinutes) {
            this.minutesAtDay.add(new Integer(TimeUtils.time2Minutes(hourWithMinutes).intValue()));
        }

        public void addMonth(int month) {
            this.months.put(new Integer(month), null);
        }

        public Timestamp getNextTimeout(Timestamp baseDateTime) {
            if (this.minutesAtDay.isEmpty()) {
                this.minutesAtDay.add(new Integer(this.hours * 60 + this.minutes));
            }
            Collections.sort(this.minutesAtDay, new Comparator<Integer>(){

                @Override
                public int compare(Integer i1, Integer i2) {
                    return i1.compareTo(i2);
                }
            });
            GregorianCalendar gc = new GregorianCalendar();
            long today = System.currentTimeMillis();
            gc.setTimeInMillis(baseDateTime.getTime());
            int baseMinutes = gc.get(11) * 60 + gc.get(12);
            gc.setTimeInMillis(today);
            int scheduledMinutes = this.getNextMinuteToRun(baseMinutes);
            if (scheduledMinutes < 0) {
                gc.add(5, 1);
            }
            while (!this.months.isEmpty() && !this.months.containsKey(new Integer(gc.get(2) + 1))) {
                gc.add(2, 1);
                gc.set(5, 1);
                scheduledMinutes = -1;
            }
            switch (this.type) {
                case 0: {
                    break;
                }
                case 1: {
                    while (!this.daysOfWeek.isEmpty() && !this.daysOfWeek.containsKey(new Integer(gc.get(7)))) {
                        gc.add(5, 1);
                        scheduledMinutes = -1;
                    }
                    break;
                }
                case 2: {
                    while (!this.daysOfMonth.isEmpty() && !this.daysOfMonth.containsKey(new Integer(gc.get(5)))) {
                        gc.add(5, 1);
                        scheduledMinutes = -1;
                    }
                    break;
                }
            }
            if (scheduledMinutes < 0) {
                scheduledMinutes = this.getNextMinuteToRun(-1);
            }
            gc.set(11, scheduledMinutes / 60);
            gc.set(12, scheduledMinutes % 60);
            gc.set(13, 0);
            return new Timestamp(gc.getTimeInMillis());
        }

        public void setHoras(int horas) {
            this.hours = horas;
        }

        public void setMinutos(int minutos) {
            this.minutes = minutos;
        }

        public void setPeriod(int startHour, int endHour, int hourPeriod) {
            int startAsMinutes = TimeUtils.time2Minutes(startHour).intValue();
            int endAsMinutes = TimeUtils.time2Minutes(endHour).intValue();
            int periodAsMinutes = TimeUtils.time2Minutes(hourPeriod).intValue();
            int next = startAsMinutes;
            do {
                this.minutesAtDay.add(new Integer(next));
            } while ((next += periodAsMinutes) <= endAsMinutes);
        }

        public void setType(int tipoDias) {
            this.type = tipoDias;
        }

        private int getNextMinuteToRun(int currentMinute) {
            for (Integer min : this.minutesAtDay) {
                if (min <= currentMinute) continue;
                return min;
            }
            return -1;
        }
    }
}

