/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class ThreadLocalsRemover {
    private Collection packPrefixes;
    private boolean logClean = Boolean.getBoolean("threadlocal.clean.log");
    private boolean removeAll = Boolean.getBoolean("anula.threadlocal.fieldlocal");

    public ThreadLocalsRemover() {
        this.packPrefixes = new ArrayList();
    }

    public void addPackagePrefix(String s) {
        this.packPrefixes.add(s);
    }

    public void doClean() throws Exception {
        Field threadLocalsField = Thread.class.getDeclaredField("threadLocals");
        threadLocalsField.setAccessible(true);
        Class<?> threadLocalMapKlazz = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
        Field tableField = threadLocalMapKlazz.getDeclaredField("table");
        tableField.setAccessible(true);
        Object fieldLocal = threadLocalsField.get(Thread.currentThread());
        if (fieldLocal == null) {
            return;
        }
        Object table = tableField.get(fieldLocal);
        int threadLocalCount = Array.getLength(table);
        ArrayList<Object> toRemove = new ArrayList<Object>();
        block0: for (int i = 0; i < threadLocalCount; ++i) {
            Object entry = Array.get(table, i);
            if (entry == null) continue;
            Field valueField = entry.getClass().getDeclaredField("value");
            valueField.setAccessible(true);
            Object value = valueField.get(entry);
            if (value == null) continue;
            String valueClass = value.getClass().getName();
            for (String packagePrefix : this.packPrefixes) {
                if (!valueClass.startsWith(packagePrefix)) continue;
                if (this.logClean) {
                    System.out.println("[ThreadLocalsRemover] clearing '" + valueClass + "' ...");
                }
                toRemove.add(entry);
                continue block0;
            }
        }
        for (Object entry : toRemove) {
            ThreadLocal t = (ThreadLocal)((WeakReference)entry).get();
            t.remove();
        }
    }

    public static class CleanableCollection
    extends ArrayList {
    }

    public static class CleanableMap
    extends HashMap {
    }
}

