/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class SyncronizedProxy
implements Serializable {
    public static Object build(Class delegateInterface, Object targetInstance) {
        return Proxy.newProxyInstance(delegateInterface.getClassLoader(), new Class[]{delegateInterface}, (InvocationHandler)new InvocationHandlerImpl(targetInstance));
    }

    private static class InvocationHandlerImpl
    implements InvocationHandler,
    Serializable {
        private Object targetInstance;

        public InvocationHandlerImpl(Object targetInstance) {
            this.targetInstance = targetInstance;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.invokeSyncronized(method, this.targetInstance, args);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Object invokeSyncronized(Method method, Object target, Object[] params) throws Exception {
            Object object = this.targetInstance;
            synchronized (object) {
                try {
                    Object object2 = method.invoke(target, params);
                    return object2;
                }
                catch (Exception e) {
                    if (e instanceof InvocationTargetException) {
                        e = (Exception)e.getCause();
                    }
                    throw e;
                }
                finally {
                    this.targetInstance.notifyAll();
                }
            }
        }
    }
}

