/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import br.com.sankhya.MethodInfo.MethodInfo;
import com.sankhya.util.StringFormat;
import com.sankhya.util.TimeUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static final int ONLY_DIGITS = 1;
    public static final int ONLY_ALPHAS = 2;
    private static String charsWithAccentuation = "\u00c1\u00c9\u00cd\u00d3\u00da_\u00c3\u00d5_\u00c2\u00ca\u00ce\u00d4\u00db_\u00c0\u00c8\u00cc\u00d2\u00d9_\u00dc_\u00c7_\u00e1\u00e9\u00ed\u00f3\u00fa_\u00e3\u00f5_\u00e2\u00ea\u00ee\u00f4\u00fb_\u00e0\u00e8\u00ec\u00f2\u00f9_\u00fc_\u00e7";
    private static String charsWithoutAccentuation = "AEIOU_AO_AEIOU_AEIOU_U_C_aeiou_ao_aeiou_aeiou_u_c";
    private StringBuffer strbuf;

    public StringUtils() {
        this.strbuf = new StringBuffer();
    }

    public StringUtils(String str) {
        this.strbuf = new StringBuffer(str == null ? "" : str);
    }

    public static Collection buildTokens(String s, String separator, TokenBuilder builder) {
        ArrayList<Object> c = new ArrayList<Object>();
        StringTokenizer tokenizer = new StringTokenizer(s, separator);
        while (tokenizer.hasMoreTokens()) {
            Object value = builder.buildToken(tokenizer.nextToken());
            if (value == null) continue;
            c.add(value);
        }
        return c;
    }

    public static Set buildTokensAsSet(String s, String separator, TokenBuilder builder) {
        HashSet<Object> c = new HashSet<Object>();
        StringTokenizer tokenizer = new StringTokenizer(s, separator);
        while (tokenizer.hasMoreTokens()) {
            Object value = builder.buildToken(tokenizer.nextToken());
            if (value == null) continue;
            c.add(value);
        }
        return c;
    }

    public static Collection<String> getLines(String s) {
        ArrayList<String> r = new ArrayList<String>();
        if ((s = StringUtils.getEmptyAsNull(s)) != null) {
            BufferedReader reader = new BufferedReader(new StringReader(s));
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    r.add(line);
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        return r;
    }

    public static BigDecimal convertToBigDecimal(String s) {
        boolean negativeSign = false;
        if ((s = StringUtils.getEmptyAsNull(s)) == null) {
            return null;
        }
        negativeSign = s.charAt(0) == '-';
        int decReward = 0;
        boolean hasNonDigit = false;
        for (int i = s.length() - 1; i >= 0; --i) {
            char c = s.charAt(i);
            if (c != '-' && !Character.isDigit(c)) {
                hasNonDigit = true;
                break;
            }
            ++decReward;
        }
        s = s.replaceAll("\\D", "");
        StringBuffer buf = new StringBuffer(s);
        if (hasNonDigit) {
            buf.insert(buf.length() - decReward, '.');
        }
        BigDecimal bigDecimalToReturn = new BigDecimal(buf.toString());
        if (negativeSign) {
            bigDecimalToReturn = bigDecimalToReturn.multiply(new BigDecimal(-1));
        }
        return bigDecimalToReturn;
    }

    @MethodInfo(name="", description="Retorna substring de val", arguments={"val", "pos", "qtd"}, category="Outra")
    public static String copy(String val, int pos, int qtd) {
        int n = pos = pos > 0 ? --pos : 0;
        if (val == null) {
            val = "";
        }
        if (pos + qtd > val.length()) {
            val = StringUtils.padr(val, pos + qtd);
        }
        return val.substring(pos, pos + qtd);
    }

    @MethodInfo(name="", description="Retorna substring de val", arguments={"val", "pos", "qtd"}, category="Outra")
    public static String copy(Object val, int pos, int qtd) {
        if (val instanceof Timestamp) {
            val = TimeUtils.formataDDMMYYYY(val);
        }
        if (val == null) {
            val = "";
        }
        return StringUtils.copy(val.toString(), pos, qtd);
    }

    @MethodInfo(name="", description="Retorna uma substring do texto", arguments={"o", "start", "count"}, category="Outra")
    public static String substr(Object o, int start, int count) {
        String s = o == null ? "" : o.toString();
        int n = start = start > 0 ? --start : 0;
        if (start >= s.length()) {
            return "";
        }
        count = Math.min(start + count, s.length());
        return s.substring(start, count);
    }

    public static void delimeterReplace(String toReplace, StringBuffer s, String openDelim, String closeDelim, int pos) {
        int start = s.lastIndexOf(openDelim, pos);
        if (start == -1) {
            return;
        }
        int end = s.indexOf(closeDelim, start + openDelim.length());
        if (end <= pos) {
            return;
        }
        s.replace(start, end + closeDelim.length(), toReplace);
    }

    public static String delimeterSubstring(String s, String openDelim, String closeDelim, int pos) {
        int start = s.lastIndexOf(openDelim, pos);
        if (start == -1) {
            return "";
        }
        int end = s.indexOf(closeDelim, start += openDelim.length());
        if (end <= pos) {
            return "";
        }
        return s.substring(start, end);
    }

    public static String formatNumeric(String format, Object value, int minSize) {
        String valstr = value != null ? value.toString() : "";
        DecimalFormat dfFormat = new DecimalFormat(format);
        String valueFormat = dfFormat.format(new BigDecimal(valstr));
        return StringUtils.padl(valueFormat, minSize == 0 ? format.length() : minSize);
    }

    @MethodInfo(name="", description="Formata o n\u00famero <value> usando a m\u00e1scara <format>", arguments={"mascara", "numero"}, category="Outra")
    public static String formatNumeric(String format, Object value) {
        return StringUtils.formatNumeric(format, value, 0);
    }

    public static String formatNumeric(Object valor) {
        return StringUtils.formatNumeric("#,##0.00;(#,##0.00)", valor, 0);
    }

    public static String formatTimestamp(Timestamp t, String format) {
        try {
            SimpleDateFormat df = new SimpleDateFormat(format);
            return df.format(new Date(t.getTime()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Imposs\u00edvel converter para uma string v\u00e1lida: " + t);
        }
    }

    public static String formataCep(String cep) {
        return StringUtils.isNotEmpty(cep) ? new StringFormat().format(cep, "##.###-###") : "";
    }

    public static String formataCfop(String format, int codCFO) {
        return new StringFormat().format(String.valueOf(codCFO), format);
    }

    public static String formataCgcCpf(String cgccpf) {
        String tipPessoa = "";
        if (cgccpf == null) {
            return "";
        }
        if (cgccpf.trim().length() == 11) {
            tipPessoa = "F";
        } else if (cgccpf.trim().length() == 14) {
            tipPessoa = "J";
        }
        return StringUtils.formataCgcCpf(tipPessoa, cgccpf);
    }

    public static String formataCgcCpf(String tipPessoa, String cgccpf) {
        String cgccpfFormatado = "";
        String cgccpfSomenteDigitos = cgccpf.replaceAll("[^\\d]", "");
        if (cgccpfSomenteDigitos.length() == 11) {
            cgccpfFormatado = StringUtils.toCPF(cgccpfSomenteDigitos);
        } else if (cgccpfSomenteDigitos.length() == 14) {
            cgccpfFormatado = StringUtils.toCNPJ(cgccpfSomenteDigitos);
        }
        return cgccpfFormatado;
    }

    public static String formataPlaca(String placa) {
        return StringUtils.isNotEmpty(placa) ? new StringFormat().format(placa, "###-####") : "";
    }

    public static String formataTelefone(String telefone) {
        return StringUtils.isNotEmpty(telefone) ? new StringFormat().format(telefone, "####-####-####") : "";
    }

    public static String formataTelefone2(String telefone) {
        return StringUtils.isNotEmpty(telefone) ? new StringFormat().format(telefone, "(####) ####-####") : "";
    }

    public static String getCollectionCommaSeparated(Collection col) {
        StringBuffer buf = new StringBuffer(col.size() * 64);
        Iterator ite = col.iterator();
        while (ite.hasNext()) {
            buf.append(ite.next() + ",");
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    public static int getDelimiterClosingPosition(CharSequence s, char open, char close, int start) {
        int curPos = start;
        int openBraces = 0;
        do {
            char c;
            if ((c = s.charAt(curPos)) == open) {
                ++openBraces;
                continue;
            }
            if (c != close) continue;
            --openBraces;
        } while (openBraces != 0 && ++curPos < s.length());
        return curPos < s.length() ? curPos : -1;
    }

    public static int getDelimiterOpeningPosition(CharSequence s, char open, char close, int start) {
        int curPos = start;
        int openBraces = 0;
        do {
            char c;
            if ((c = s.charAt(curPos)) == open) {
                ++openBraces;
                continue;
            }
            if (c != close) continue;
            --openBraces;
        } while (openBraces != 0 && --curPos >= 0);
        return curPos >= 0 ? curPos : -1;
    }

    public static String getEmptyAsNull(String s) {
        return s == null || s.trim().length() == 0 ? null : s.trim();
    }

    public static String getNullAsEmpty(String arg0) {
        if (arg0 == null) {
            return "";
        }
        return arg0;
    }

    public static String getNullAsEmpty(Object arg0) {
        if (arg0 == null) {
            return "";
        }
        return arg0.toString();
    }

    public static boolean isDelimitersBalanced(String s, char open, char close) {
        int count = 0;
        int curPos = 0;
        while (curPos < s.length()) {
            char c;
            if ((c = s.charAt(curPos++)) == open) {
                ++count;
                continue;
            }
            if (c != close) continue;
            --count;
        }
        return open == close ? !(count & true) : count == 0;
    }

    public static boolean isEmpty(Object s) {
        if (s == null) {
            return true;
        }
        return StringUtils.getEmptyAsNull(s.toString()) == null;
    }

    public static boolean isEmpty(String s) {
        return StringUtils.getEmptyAsNull(s) == null;
    }

    public static boolean isNotEmpty(Object s) {
        if (s == null) {
            return false;
        }
        return StringUtils.getEmptyAsNull(s.toString()) != null;
    }

    public static String joinArray(String[] source, String separator) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < source.length; ++i) {
            if (buf.length() > 0) {
                buf.append(separator);
            }
            buf.append(source[i]);
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        System.out.println(StringUtils.stringZero("41", 5));
    }

    @MethodInfo(name="", description="Retorna parte final do texto, complementado com espa\u00e7os.", arguments={"value", "width"}, category="Outra")
    public static String pad(Object value, int width) {
        return StringUtils.padr(value, width, ' ');
    }

    public static String padc(Object value, int width, char fill) {
        String valstr = value != null ? value.toString() : "";
        StringBuffer sbuf = new StringBuffer();
        if (valstr.length() <= width) {
            int i;
            int difer = width - valstr.length();
            int f1 = difer / 2;
            int f2 = difer - f1;
            for (i = 0; i < f1; ++i) {
                sbuf.append(fill);
            }
            sbuf.append(valstr);
            for (i = 0; i < f2; ++i) {
                sbuf.append(fill);
            }
        } else {
            sbuf.append(valstr.substring(0, width));
        }
        return sbuf.toString();
    }

    public static String padl(Object value, int width, char fill) {
        StringBuffer valstr = new StringBuffer(value != null ? value.toString() : "");
        if (valstr.length() > 0) {
            int last;
            for (last = 0; last < valstr.length() && valstr.charAt(last) == fill; ++last) {
            }
            valstr.delete(0, last);
        }
        if (valstr.length() < width) {
            while (valstr.length() < width) {
                valstr.insert(0, fill);
            }
        } else {
            valstr.delete(width, valstr.length());
        }
        return valstr.toString();
    }

    @MethodInfo(name="pae", description="Retorna parte inicial do texto, complementado com espa\u00e7os.Similar ao <pae>", arguments={"value", "width"}, category="Outra")
    public static String padl(Object value, int width) {
        return StringUtils.padl(value, width, ' ');
    }

    public static String padr(Object value, int width, char fill) {
        String valstr = value != null ? value.toString() : "";
        StringBuffer sbuf = new StringBuffer(valstr);
        if (valstr.length() <= width) {
            for (int i = 0; i < width - valstr.length(); ++i) {
                sbuf.append(fill);
            }
        } else {
            sbuf.setLength(width);
        }
        return sbuf.toString();
    }

    public static String padr(Object value, int width, String fill) {
        if (fill == null) {
            throw new IllegalArgumentException("O argumento fill n\u00e3o pode ser nulo");
        }
        if (fill.length() <= 0) {
            throw new IllegalArgumentException("O argumento fill deve ter comprimento maior que zero!");
        }
        String valstr = value != null ? value.toString() : "";
        StringBuffer sbuf = new StringBuffer(valstr);
        if (valstr.length() <= width) {
            for (int i = 0; i < width - valstr.length(); ++i) {
                sbuf.append(fill.charAt(i % fill.length()));
            }
        } else {
            sbuf.setLength(width);
        }
        return sbuf.toString();
    }

    public static String replaceAccentuatedChars(String text) {
        StringBuffer buf = new StringBuffer(text);
        StringUtils.replaceAccentuatedChars(buf);
        return buf.toString();
    }

    public static void replaceAccentuatedChars(StringBuffer source) {
        block0: for (int i = 0; i < source.length(); ++i) {
            char sourceChar = source.charAt(i);
            for (int j = 0; j < charsWithAccentuation.length(); ++j) {
                char charWithAcc = charsWithAccentuation.charAt(j);
                if (Character.toUpperCase(sourceChar) != Character.toUpperCase(charWithAcc)) continue;
                char charToReplace = charsWithoutAccentuation.charAt(j);
                if (Character.isLowerCase(sourceChar)) {
                    charToReplace = Character.toLowerCase(charToReplace);
                }
                source.deleteCharAt(i);
                source.insert(i, charToReplace);
                continue block0;
            }
        }
    }

    public StringUtils append(String str) {
        this.strbuf = null;
        this.strbuf = new StringBuffer(str);
        return this;
    }

    public int countChars(char c) {
        int count = 0;
        for (int i = 0; i < this.strbuf.toString().length(); ++i) {
            if (this.strbuf.toString().charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static int countChars(String s, char c) {
        int count = 0;
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != c) continue;
            ++count;
        }
        return count;
    }

    public static int countOcorrences(String search, StringBuffer buf) {
        int startIndex = 0;
        int fromIndex = 0;
        int count = 0;
        while ((startIndex = buf.indexOf(search, fromIndex)) > -1) {
            ++count;
            fromIndex = startIndex + search.length();
        }
        return count;
    }

    @Deprecated
    public static boolean empty(String str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                if (str.charAt(i) == ' ') continue;
                return false;
            }
        }
        return true;
    }

    public static String monthYear(String yearMonth) {
        if (StringUtils.getEmptyAsNull(yearMonth) == null) {
            return null;
        }
        String ano = yearMonth.substring(0, 4);
        String mes = yearMonth.substring(4, yearMonth.length());
        return mes + "/" + ano;
    }

    public static void replicate(StringBuffer buf, String s, int count) {
        for (int i = 0; i < count; ++i) {
            buf.append(s);
        }
    }

    public static String replicate(String s, int count) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            buf.append(s);
        }
        return buf.toString();
    }

    public StringUtils deleteChars(char c) {
        return this.deleteChars(c, 0);
    }

    public StringUtils deleteChars(char c, int count) {
        return this.deleteChars(c, count, false);
    }

    public StringUtils deleteChars(char c, int count, boolean from) {
        try {
            int indexof;
            for (int deleteds = 0; (indexof = !from ? this.strbuf.toString().indexOf(c) : this.strbuf.toString().lastIndexOf(c)) != -1 && (count <= 0 || deleteds < count); ++deleteds) {
                this.strbuf.deleteCharAt(indexof);
            }
        }
        catch (IndexOutOfBoundsException ignored) {
            // empty catch block
        }
        return this;
    }

    public StringUtils deleteExcept(int start, int end) {
        return this.deleteExcept(start, end, null);
    }

    public StringUtils deleteExcept(int start, int end, String except) {
        try {
            int next = start;
            for (int i = start; i < end; ++i) {
                char c = this.strbuf.charAt(next);
                if (except != null && -1 != except.indexOf(c)) {
                    ++next;
                    continue;
                }
                this.strbuf.deleteCharAt(next);
            }
        }
        catch (IndexOutOfBoundsException iob) {
            // empty catch block
        }
        return this;
    }

    public StringUtils format(String str, String strFormat, char blankChar) {
        int insertPointStart = 0;
        int strSize = str == null ? 0 : str.length();
        this.strbuf.setLength(0);
        this.strbuf.append(strFormat);
        try {
            int strIndex = 0;
            for (int i = 0; i < strFormat.length(); ++i) {
                char c = strFormat.charAt(i);
                if (c == '#') {
                    if (strIndex < strSize) {
                        this.strbuf.setCharAt(i, str.charAt(strIndex));
                        ++strIndex;
                        continue;
                    }
                    this.strbuf.setCharAt(i, blankChar);
                    continue;
                }
                if (c != '|') continue;
                int insertPoint = this.strbuf.indexOf("|", insertPointStart);
                this.strbuf.deleteCharAt(insertPoint);
                this.strbuf.insert(insertPoint, str);
                insertPointStart = insertPoint + str.length();
            }
        }
        catch (IndexOutOfBoundsException iob) {
            // empty catch block
        }
        return this;
    }

    @MethodInfo(name="", description="Ret.parte inicial do texto", arguments={"texto", "tamanho"}, category="Outra")
    public static String left(Object value, int count) {
        String valstr = value != null ? value.toString() : "";
        return valstr.length() > count ? valstr.substring(0, count) : valstr;
    }

    @MethodInfo(name="", description="Ret.parte final do texto", arguments={"texto", "tamanho"}, category="Outra")
    public static String right(Object value, int count) {
        String valstr = value != null ? value.toString() : "";
        return valstr.substring(Math.max(valstr.length() - count, 0), valstr.length());
    }

    public StringUtils padc(int width) {
        return this.padc(width, ' ');
    }

    public StringUtils padc(int width, char fill) {
        String tmp = this.strbuf.toString();
        this.strbuf.setLength(0);
        this.strbuf.append(StringUtils.padc(tmp, width, fill));
        return this;
    }

    public static String padc(Object value, int width) {
        return StringUtils.padc(value, width, ' ');
    }

    public StringUtils padl(int width) {
        return this.padl(width, ' ');
    }

    public StringUtils padl(int width, char fill) {
        String tmp = this.strbuf.toString();
        this.strbuf.setLength(0);
        this.strbuf.append(StringUtils.padl(tmp, width, fill));
        return this;
    }

    public StringUtils padr(int width) {
        return this.padr(width, ' ');
    }

    public StringUtils padr(int width, char fill) {
        String tmp = this.strbuf.toString();
        this.strbuf.setLength(0);
        this.strbuf.append(StringUtils.padr((Object)tmp, width, fill));
        return this;
    }

    @MethodInfo(name="", description="Retorna parte final do texto, complementado com espa\u00e7os.", arguments={"value", "width"}, category="Outra")
    public static String padr(Object value, int width) {
        return StringUtils.padr(value, width, ' ');
    }

    public static String removePontuacao(String s) {
        if (s == null) {
            return null;
        }
        return s.replaceAll("[.,;:?!]", "");
    }

    public static Map removeTokens(StringBuffer inputBuffer, String delimeters, String tokenId) {
        TreeMap<String, String> literals = new TreeMap<String, String>();
        StringBuffer currentString = new StringBuffer();
        StringBuffer workBuffer = new StringBuffer();
        boolean isInsideString = false;
        char stringDelimeter = '\u0000';
        char c = '\u0000';
        if (delimeters.length() % 2 > 0) {
            throw new IllegalArgumentException("removeTokens com largura de delimitador inv\u00e1lida.");
        }
        byte[] delimeterBytes = delimeters.getBytes();
        int delimeterSize = delimeterBytes.length / 2;
        byte[] enterDelimeter = new byte[delimeterSize];
        byte[] exitDelimeter = new byte[delimeterSize];
        int arrayIdx = 0;
        for (int i = 0; i < delimeterSize; ++i) {
            enterDelimeter[i] = delimeterBytes[arrayIdx++];
            exitDelimeter[i] = delimeterBytes[arrayIdx++];
        }
        String inDelimeter = new String(enterDelimeter);
        String outDelimeter = new String(exitDelimeter);
        int delimeterIndex = 0;
        char[] chars = inputBuffer.toString().toCharArray();
        boolean inOutEquals = false;
        int size = chars.length;
        int stringCount = 0;
        for (int i = 0; i < size; ++i) {
            c = chars[i];
            if (isInsideString) {
                char previousChar = i > 0 ? chars[i - 1] : (char)'\u0000';
                char nextChar = i < size - 1 ? chars[i + 1] : (char)'\u0000';
                char currentChar = chars[i];
                if (stringDelimeter == c && (!inOutEquals || previousChar != stringDelimeter && nextChar != stringDelimeter || currentChar == stringDelimeter)) {
                    currentString.append(c);
                    isInsideString = false;
                    stringDelimeter = '\u0000';
                    String token = "${" + tokenId + stringCount + '}';
                    workBuffer.append(token);
                    literals.put(token, currentString.toString());
                    currentString.setLength(0);
                    ++stringCount;
                    continue;
                }
                currentString.append(c);
                continue;
            }
            delimeterIndex = inDelimeter.indexOf(c);
            if (delimeterIndex > -1) {
                isInsideString = true;
                stringDelimeter = outDelimeter.charAt(delimeterIndex);
                inOutEquals = inDelimeter.charAt(delimeterIndex) == outDelimeter.charAt(delimeterIndex);
                currentString.append(c);
                continue;
            }
            workBuffer.append(c);
        }
        if (isInsideString) {
            throw new IllegalArgumentException("Delimitador '" + stringDelimeter + "' desbalanceado");
        }
        inputBuffer.setLength(0);
        inputBuffer.append(workBuffer.toString());
        return literals;
    }

    public static Map removeQuotes(StringBuffer s, char normalizedDelimiter) {
        HashMap<String, String> m = new HashMap<String, String>();
        int index = 0;
        boolean isInside = false;
        char openDelimiter = '\u0000';
        StringBuffer tokenBuf = new StringBuffer();
        StringBuffer workBuf = new StringBuffer();
        int tokenCount = 0;
        boolean isLast = false;
        while (!isLast) {
            boolean isQuotes;
            char curChar = s.charAt(index);
            isLast = index == s.length() - 1;
            char prev = index > 0 ? s.charAt(index - 1) : (char)'\u0000';
            char next = isLast ? (char)'\u0000' : s.charAt(index + 1);
            boolean isEscape = curChar == '\\' && (next == '\'' || next == '\"');
            boolean bl = isQuotes = curChar == '\'' || curChar == '\"';
            if (isInside) {
                if (isQuotes) {
                    if (prev == '\\') {
                        tokenBuf.append(curChar);
                    } else if (openDelimiter == curChar) {
                        String tokenKey = "${S" + tokenCount + "}";
                        tokenBuf.append(normalizedDelimiter);
                        m.put(tokenKey, tokenBuf.toString());
                        workBuf.append(tokenKey);
                        ++tokenCount;
                        isInside = false;
                    } else {
                        tokenBuf.append(curChar);
                    }
                } else if (curChar != '\\' || next != '\'' && next != '\"') {
                    tokenBuf.append(curChar);
                }
            } else if (isQuotes && prev != '\\') {
                tokenBuf.setLength(0);
                tokenBuf.append(normalizedDelimiter);
                isInside = true;
                openDelimiter = curChar;
            } else if (!isEscape) {
                workBuf.append(curChar);
            }
            ++index;
        }
        if (isInside) {
            throw new IllegalStateException("Aspas desbalanceadas: " + openDelimiter);
        }
        s.setLength(0);
        s.append(workBuf.toString());
        return m;
    }

    public StringUtils replaceChars(char toFind, char toReplace) {
        return this.replaceChars(toFind, toReplace, 0);
    }

    public StringUtils replaceChars(char toFind, char toReplace, int count) {
        return this.replaceChars(toFind, toReplace, count, false);
    }

    public StringUtils replaceChars(char toFind, char toReplace, int count, boolean from) {
        int indexof;
        for (int replaces = 0; (indexof = !from ? this.strbuf.toString().indexOf(toFind) : this.strbuf.toString().lastIndexOf(toFind)) != -1 && (count <= 0 || replaces < count); ++replaces) {
            this.strbuf.setCharAt(indexof, toReplace);
        }
        return this;
    }

    public StringUtils replacePattern(char toReplace) {
        return this.replacePattern(toReplace, 0);
    }

    public StringUtils replacePattern(char toReplace, int start) {
        return this.replacePattern(toReplace, start, this.strbuf.length());
    }

    public StringUtils replacePattern(char toReplace, int start, int end) {
        return this.replacePattern(toReplace, start, end, null);
    }

    public StringUtils replacePattern(char toReplace, int start, int end, String exceptChars) {
        try {
            for (int i = start; i <= end; ++i) {
                if (exceptChars != null && -1 != exceptChars.indexOf(this.strbuf.charAt(i))) continue;
                this.strbuf.setCharAt(i, toReplace);
            }
        }
        catch (IndexOutOfBoundsException iob) {
            // empty catch block
        }
        return this;
    }

    public StringUtils replaceString(String stringToFind, String stringToReplace) {
        String str = StringUtils.replaceString(this.strbuf.toString(), stringToFind, stringToReplace);
        this.strbuf.delete(0, this.strbuf.length());
        this.strbuf.append(str);
        return this;
    }

    @MethodInfo(name="substitui", description="Substitui stringToFind em source por stringToReplace", arguments={"source", "stringToFind", "stringToReplace"}, category="Outra")
    public static String replaceString(String source, String stringToFind, String stringToReplace) {
        int foundIndex;
        StringBuffer buf = new StringBuffer(source);
        int startSearch = 0;
        int targetSize = stringToFind.length();
        while ((foundIndex = buf.toString().indexOf(stringToFind, startSearch)) != -1) {
            buf.delete(foundIndex, foundIndex + targetSize);
            buf.insert(foundIndex, stringToReplace);
        }
        return buf.toString();
    }

    public static void replaceString(String search, String replace, StringBuffer buf, boolean replaceAll) {
        boolean replaceConstainsSearch;
        int startIndex = 0;
        if (replace == null) {
            replace = "";
        }
        boolean bl = replaceConstainsSearch = replace.indexOf(search) > -1;
        while ((startIndex = buf.indexOf(search, startIndex)) > -1) {
            buf.replace(startIndex, startIndex + search.length(), replace);
            if (replaceConstainsSearch) {
                startIndex += replace.length();
            }
            if (replaceAll) continue;
            break;
        }
    }

    public static void rollbackTokens(StringBuffer buf, Map tokens, String tokenId) {
        Matcher m = Pattern.compile("\\$\\{" + tokenId + "\\d+\\}", 32).matcher(buf);
        ArrayList<String> c = new ArrayList<String>();
        while (m.find()) {
            c.add(m.group());
        }
        for (String token : c) {
            StringUtils.replaceString(token, (String)tokens.get(token), buf, false);
        }
    }

    public static String rtrim(String s) {
        int start;
        int i;
        if (s == null) {
            return null;
        }
        for (i = start = s.length() - 1; i >= 0 && s.charAt(i) == ' '; --i) {
        }
        if (i < start) {
            s = s.substring(0, i + 1);
        }
        return s;
    }

    public StringUtils setPattern(int pattern) {
        int i = 0;
        while (i < this.strbuf.length()) {
            char c = this.strbuf.charAt(i);
            switch (pattern) {
                case 1: {
                    if (!Character.isDigit(c)) {
                        this.strbuf.deleteCharAt(i);
                        break;
                    }
                    ++i;
                    break;
                }
                case 2: {
                    if (Character.isDigit(c)) {
                        this.strbuf.deleteCharAt(i);
                        break;
                    }
                    ++i;
                }
            }
        }
        return this;
    }

    public StringUtils stringZero(int width) {
        String tmp = this.strbuf.toString();
        this.strbuf.setLength(0);
        this.strbuf.append(StringUtils.stringZero(tmp, width));
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String stringZero(Object value, int width, boolean truncOverFlow) {
        String valstr;
        StringBuffer sbuf = new StringBuffer();
        String string = valstr = value == null ? "" : value.toString();
        if (valstr.length() > width) {
            if (!truncOverFlow) return valstr;
            for (int i = 0; i < width; ++i) {
                sbuf.append('*');
            }
            return sbuf.toString();
        } else {
            if (valstr.length() > width) return sbuf.toString();
            for (int i = 0; i < width - valstr.length(); ++i) {
                sbuf.append('0');
            }
            sbuf.append(valstr);
        }
        return sbuf.toString();
    }

    @MethodInfo(name="StrZero", description="Preenche value com zeros a esquerda at\u00e9 o limite de width", arguments={"value", "width"}, category="Matem\u00e1tica & Trig")
    public static String stringZero(Object value, int width) {
        return StringUtils.stringZero(value, width, true);
    }

    public boolean empty() {
        return StringUtils.empty(this.strbuf.toString());
    }

    public static String hexStr2decStr(String s) {
        StringBuffer mainBuf = new StringBuffer();
        for (int i = 0; i < s.length(); i += 2) {
            mainBuf.append((char)Integer.parseInt(s.substring(i, i + 2), 16));
        }
        return mainBuf.toString();
    }

    public static byte[] toByteArray(String s) {
        try {
            return s.getBytes();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Imposs\u00edvel converter para um array de bytes: " + s);
        }
    }

    public static String toCNPJ(String cnpjDigits) throws IllegalArgumentException {
        if (cnpjDigits.length() < 14) {
            throw new IllegalArgumentException("N\u00famero de CNPJ inv\u00e1lido: n\u00famero de d\u00edgitos menor que 14");
        }
        if (cnpjDigits.length() > 14) {
            throw new IllegalArgumentException("N\u00famero de CNPJ inv\u00e1lido: n\u00famero de d\u00edgitos maior que 14");
        }
        StringFormat cnpjFormat = new StringFormat();
        cnpjFormat.setPattern("##.###.###/####-##");
        return cnpjFormat.format(cnpjDigits);
    }

    public static String toCPF(String cpfDigits) throws IllegalArgumentException {
        if (cpfDigits.length() < 11) {
            throw new IllegalArgumentException("N\u00famero de CPF inv\u00e1lido: n\u00famero de d\u00edgitos menor que 11");
        }
        if (cpfDigits.length() > 11) {
            throw new IllegalArgumentException("N\u00famero de CPF inv\u00e1lido: n\u00famero de d\u00edgitos maior que 11");
        }
        StringFormat cnpjFormat = new StringFormat();
        cnpjFormat.setPattern("###.###.###-##");
        return cnpjFormat.format(cpfDigits);
    }

    public static char[] toCharArray(String s) {
        try {
            return s.toCharArray();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Imposs\u00edvel converter para um array de caracteres: " + s);
        }
    }

    public static BigDecimal toCurrency(String s) {
        try {
            return new BigDecimal(new DecimalFormat("###,###,##0.00").parse(s).doubleValue()).setScale(2, 4);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Imposs\u00edvel converter para um valor: " + s);
        }
    }

    public static Timestamp toDate(String s) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
            return new Timestamp(df.parse(s).getTime());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Imposs\u00edvel converter para uma data v\u00e1lida: " + s);
        }
    }

    public static Timestamp toDateTime(String s) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm");
            return new Timestamp(df.parse(s).getTime());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Imposs\u00edvel converter para uma data e hora v\u00e1lida: " + s);
        }
    }

    public static String toHexString(byte[] b) {
        StringBuffer mainBuf = new StringBuffer(b.length * 2);
        int radix = 16;
        int mask = radix - 1;
        for (int i = 0; i < b.length; ++i) {
            int value = b[i] & 0xFF;
            char[] c = new char[]{'0', '0'};
            int flipI = 2;
            do {
                c[--flipI] = digits[value & mask];
            } while ((value >>>= 4) != 0);
            mainBuf.append(c);
        }
        return mainBuf.toString();
    }

    public static BigDecimal toNumber(String s) {
        try {
            return new BigDecimal(s);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Imposs\u00edvel converter para um n\u00famero: " + s);
        }
    }

    public String toString() {
        return this.strbuf.toString();
    }

    public StringBuffer toStringBuffer() {
        return this.strbuf;
    }

    public static Timestamp toTime(String s) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("HH:mm");
            return new Timestamp(df.parse(s).getTime());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Imposs\u00edvel converter para uma hora v\u00e1lida: " + s);
        }
    }

    public static void wrapLines(StringBuffer buf, int lineWidth) {
        int i = 0;
        int lastLineEnd = 0;
        while (i < buf.length()) {
            int endOfLine;
            int limit = Math.min(buf.length(), i + lineWidth);
            for (endOfLine = i; endOfLine < limit && buf.charAt(endOfLine) != '\n'; ++endOfLine) {
            }
            if (endOfLine >= buf.length()) break;
            while (endOfLine > lastLineEnd && !Character.isWhitespace(buf.charAt(endOfLine))) {
                --endOfLine;
            }
            if (endOfLine == lastLineEnd) {
                endOfLine = limit;
            }
            if (buf.charAt(endOfLine) != '\n') {
                buf.insert(endOfLine, '\n');
            }
            lastLineEnd = endOfLine;
            i = endOfLine + 1;
            while (i < buf.length() && Character.isWhitespace(buf.charAt(i))) {
                buf.deleteCharAt(i);
            }
        }
    }

    public static String getNomeArquivo(String caminho) {
        int lastLeftBar = caminho.lastIndexOf("\\");
        int lastRightBar = caminho.lastIndexOf("/");
        int index = lastLeftBar;
        if (lastLeftBar < lastRightBar) {
            index = lastRightBar;
        }
        if (index > -1 && caminho.length() > index + 1) {
            caminho = caminho.substring(index + 1);
        }
        return caminho;
    }

    public static String removerCaracteresEspeciais(String s) throws Exception {
        if (s != null) {
            StringBuffer stringConvertida = new StringBuffer(s);
            for (int i = 0; i < s.length(); ++i) {
                int codePoint = s.codePointAt(i);
                if (!(codePoint > 13 && codePoint < 32 || codePoint > 127 && codePoint < 160) && codePoint <= 255) continue;
                stringConvertida.replace(i, i + 1, "?");
            }
            return stringConvertida.toString();
        }
        return null;
    }

    public static String prefix(String str, int len) {
        return str.length() > len ? str.substring(0, len) : str;
    }

    @MethodInfo(name="", description="Remove espa\u00e7os em branco no in\u00edcio e final do texto", arguments={"str"}, category="Outra")
    public static String trim(String str) {
        String trimmedStr = str == null ? "" : str.trim();
        return trimmedStr;
    }

    public static String digitoVerificador(String digitos) {
        int soma = 0;
        int multiplicador = 2;
        for (int i = digitos.length() - 1; i >= 0; --i) {
            int valorDigito = Integer.parseInt(digitos.substring(i, i + 1));
            soma += valorDigito * multiplicador++;
            if (multiplicador <= 9) continue;
            multiplicador = 2;
        }
        int resto = soma % 11;
        return String.valueOf(resto > 1 ? 11 - resto : 0);
    }

    public static String secureSubstring(String s, int start, int end) {
        if (s == null) {
            return null;
        }
        if (start >= s.length()) {
            return "";
        }
        if (end < start) {
            end = start;
        }
        return s.substring(start, Math.min(end, s.length()));
    }

    public static String normalizeFileName(String nomeArquivo) {
        if (StringUtils.getEmptyAsNull(nomeArquivo) == null) {
            throw new IllegalArgumentException("Nome do arquivo inv\u00e1lido");
        }
        if (nomeArquivo.indexOf("\\") > -1) {
            nomeArquivo = nomeArquivo.replaceAll("\\\\", "/");
        }
        return nomeArquivo;
    }

    public static boolean safelyEquals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    public static interface TokenBuilder {
        public Object buildToken(String var1);
    }
}

