/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import java.util.HashMap;

public class StringFormat {
    private static HashMap compiledPatterns = new HashMap();
    private CompiledPattern currentPattern;
    private char defaultChar = (char)32;

    public void setPattern(String pattern) {
        this.currentPattern = (CompiledPattern)compiledPatterns.get(pattern);
        if (this.currentPattern != null) {
            return;
        }
        try {
            this.currentPattern = new CompiledPattern();
            StringBuffer buf = new StringBuffer(pattern);
            int directionParamIdx = 0;
            int deleteParamIdx = 0;
            boolean charToDel = false;
            directionParamIdx = buf.indexOf("%rev%");
            if (directionParamIdx > -1) {
                buf.delete(directionParamIdx, directionParamIdx + 5);
                this.currentPattern.setReverse(true);
            }
            if ((deleteParamIdx = buf.indexOf("%del[")) > -1) {
                int delParamEnd = buf.indexOf("]%", deleteParamIdx);
                this.currentPattern.setCharsToDelete(buf.substring(deleteParamIdx + 5, delParamEnd));
                buf.delete(deleteParamIdx, delParamEnd + 2);
            }
            if (this.currentPattern.isReverse()) {
                this.currentPattern.setPatternStartIdx(buf.length() - 1);
                this.currentPattern.setEndOfJob(-1);
                this.currentPattern.setIncrement(-1);
            } else {
                this.currentPattern.setPatternStartIdx(0);
                this.currentPattern.setEndOfJob(buf.length());
                this.currentPattern.setIncrement(1);
            }
            this.currentPattern.setPattern(buf.toString());
            compiledPatterns.put(pattern, this.currentPattern);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Formato de argumento inv\u00e1lido : " + pattern);
        }
    }

    public String format(String strToFormat, String pattern) {
        this.setPattern(pattern);
        return this.format(strToFormat);
    }

    public String format(String strToFormat) {
        int insertPointStart;
        if (this.currentPattern == null) {
            throw new IllegalStateException("Nenhum padr\u00e3o de formato foi definido, use StringFormat.setPattern()");
        }
        String pattern = this.currentPattern.getPattern();
        String charsToDelete = this.currentPattern.getCharsToDelete();
        boolean reverse = this.currentPattern.isReverse();
        StringBuffer buf = new StringBuffer(pattern);
        int patternStartIdx = this.currentPattern.getPatternStartIdx();
        int endOfJob = this.currentPattern.getEndOfJob();
        int increment = this.currentPattern.getIncrement();
        int strIndex = 0;
        int strSize = 0;
        int n = insertPointStart = !reverse ? 0 : buf.length() - 1;
        if (strToFormat == null) {
            strToFormat = "";
        }
        try {
            if (charsToDelete != null) {
                StringBuffer strbuf = new StringBuffer();
                for (int i = 0; i < strToFormat.length(); ++i) {
                    char c = strToFormat.charAt(i);
                    if (charsToDelete.indexOf(c) != -1) continue;
                    strbuf.append(c);
                }
                strToFormat = strbuf.toString();
            }
            strIndex = reverse ? strToFormat.length() - 1 : 0;
            strSize = strToFormat.length();
            for (int curIndex = patternStartIdx; curIndex != endOfJob; curIndex += increment) {
                char c = pattern.charAt(curIndex);
                if (c == '#') {
                    if (!reverse ? strIndex < strSize : strIndex > -1) {
                        buf.setCharAt(curIndex, strToFormat.charAt(strIndex));
                        strIndex += increment;
                        continue;
                    }
                    buf.setCharAt(curIndex, this.defaultChar);
                    continue;
                }
                if (c != '|') continue;
                int insertPoint = !reverse ? buf.indexOf("|", insertPointStart) : buf.lastIndexOf("|", insertPointStart);
                buf.deleteCharAt(insertPoint);
                buf.insert(insertPoint, strToFormat);
                insertPointStart = !reverse ? insertPoint + strToFormat.length() : insertPoint - 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    public static void main(String[] args) throws Exception {
        StringFormat form = new StringFormat();
        form.setPattern("###.###/###.###");
        System.out.println("[" + form.format("123456789012") + "]");
    }

    public void setDefaultChar(char defaultChar) {
        this.defaultChar = defaultChar;
    }

    private class CompiledPattern {
        private String pattern;
        private boolean reverse;
        private int patternStartIdx;
        private int endOfJob;
        private int increment;
        private String charsToDelete;

        private CompiledPattern() {
        }

        public String getCharsToDelete() {
            return this.charsToDelete;
        }

        public int getEndOfJob() {
            return this.endOfJob;
        }

        public int getIncrement() {
            return this.increment;
        }

        public String getPattern() {
            return this.pattern;
        }

        public int getPatternStartIdx() {
            return this.patternStartIdx;
        }

        public boolean isReverse() {
            return this.reverse;
        }

        public void setCharsToDelete(String string) {
            this.charsToDelete = string;
        }

        public void setEndOfJob(int i) {
            this.endOfJob = i;
        }

        public void setIncrement(int i) {
            this.increment = i;
        }

        public void setPattern(String string) {
            this.pattern = string;
        }

        public void setPatternStartIdx(int i) {
            this.patternStartIdx = i;
        }

        public void setReverse(boolean b) {
            this.reverse = b;
        }
    }
}

