/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import com.sankhya.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SkwBinaryInfo {
    public static final Pattern TSIPAR_TEXTPATTERN = Pattern.compile("Vers\u00e3o SankhyaW:\\s*((\\d+\\.\\d+\\.\\d+|desenvolvimento)b\\d+)\\s*Nro de Revis\u00e3o:\\s*(\\d+)\\s*ID da Compila\u00e7\u00e3o:\\s*(\\d+)\\s*Data da Compila\u00e7\u00e3o:\\s*(\\d{2}/\\d{2}/\\d{4}\\s*\\d{2}:\\d{2}:\\d{2})", 8);
    public static final SimpleDateFormat DATEFORMAT_STD = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    private String skwVersion = "";
    private long revionNumber = 0L;
    private long buildId = 0L;
    private Date buildDate;

    public String getSkwVersion() {
        return this.skwVersion;
    }

    public void setSkwVersion(String skwVersion) {
        this.skwVersion = skwVersion;
    }

    public long getRevionNumber() {
        return this.revionNumber;
    }

    public void setRevionNumber(long revionNumber) {
        this.revionNumber = revionNumber;
    }

    public long getBuildId() {
        return this.buildId;
    }

    public void setBuildId(long buildId) {
        this.buildId = buildId;
    }

    public Date getBuildDate() {
        return this.buildDate;
    }

    public void setBuildDate(Date dtBuild) {
        this.buildDate = dtBuild;
    }

    public String getConentAsHtml() {
        StringBuilder stb = new StringBuilder();
        stb.append("<b>Vers\u00e3o SankhyaW: <b>");
        stb.append(StringUtils.getNullAsEmpty(this.skwVersion));
        stb.append("<br/><b>Nro de Revis\u00e3o: </b>");
        stb.append(this.revionNumber);
        stb.append("<br/><b>ID da Compila\u00e7\u00e3o: </b>");
        stb.append(this.buildId);
        stb.append("<br/><b>Data da Compila\u00e7\u00e3o: </b>");
        if (this.buildDate != null) {
            stb.append(DATEFORMAT_STD.format(this.buildDate));
        }
        return stb.toString();
    }

    public String getContentAsTsiparText() {
        StringBuilder stb = new StringBuilder();
        stb.append("Vers\u00e3o SankhyaW: ");
        stb.append(this.skwVersion);
        stb.append("\nNro de Revis\u00e3o: ");
        stb.append(this.revionNumber);
        stb.append("\nID da Compila\u00e7\u00e3o: ");
        stb.append(this.buildId);
        stb.append("\nData da Compila\u00e7\u00e3o: ");
        if (this.buildDate != null) {
            stb.append(DATEFORMAT_STD.format(this.buildDate));
        }
        return stb.toString();
    }

    public static SkwBinaryInfo fromTsiparText(String tsiparSkwBinTextParam) throws Exception {
        Matcher m = TSIPAR_TEXTPATTERN.matcher(tsiparSkwBinTextParam);
        SkwBinaryInfo skwBinaryInfo = null;
        if (m.find()) {
            skwBinaryInfo = new SkwBinaryInfo();
            skwBinaryInfo.skwVersion = m.group(1);
            skwBinaryInfo.revionNumber = Long.parseLong(m.group(3));
            skwBinaryInfo.buildId = Long.parseLong(m.group(4));
            skwBinaryInfo.buildDate = DATEFORMAT_STD.parse(m.group(5));
        }
        return skwBinaryInfo;
    }

    public static void main(String ... strings) {
        SkwBinaryInfo binInfo = new SkwBinaryInfo();
        binInfo.skwVersion = "2.8.0b1";
        binInfo.revionNumber = 1000L;
        binInfo.buildId = 1L;
        binInfo.buildDate = new Date(System.currentTimeMillis());
        System.out.println(binInfo.getContentAsTsiparText());
    }
}

