/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.fileupload.disk.DiskFileItem;

public class SessionFile
extends DiskFileItem
implements Serializable {
    private static final String VIEWER_FILE_DIR_NAME = "viewerfile";
    private static final int MAX_FILE_SIZE = 10240;
    private boolean canSendViaEmail;

    private SessionFile(String fieldName, String contentType, boolean isFormField, String fileName, int sizeThreshold, File repository) throws IOException {
        super(fieldName, contentType, isFormField, fileName, sizeThreshold, repository);
    }

    public void setCanSendViaEmail(boolean canSend) throws Exception {
        this.canSendViaEmail = canSend;
    }

    public boolean isCanSendViaEmail() {
        return this.canSendViaEmail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionFile createSessionFile(String fileName, String contentType, byte[] bytes) throws IOException {
        SessionFile file = new SessionFile(null, contentType, false, fileName, 10240, SessionFile.getTempViewerFileDir());
        OutputStream output = null;
        try {
            output = file.getOutputStream();
            output.write(bytes);
            output.flush();
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
        return file;
    }

    public static File getTempViewerFileDir() {
        String jbossTempDir = System.getProperty("jboss.server.temp.dir");
        File tempFolder = new File(jbossTempDir + File.separator + VIEWER_FILE_DIR_NAME);
        if (!tempFolder.exists()) {
            tempFolder.mkdir();
        }
        return tempFolder;
    }
}

