/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import java.util.Collection;

public class SQLUtils {
    private static final int IN_CLAUSE_MAX_PARAMS = 1000;

    private SQLUtils() {
    }

    public static String buildINClause(String fieldName, int totalPlaceholders) {
        return SQLUtils.buildINClause(fieldName, totalPlaceholders, 1000);
    }

    public static String buildINClause(String fieldName, int totalPlaceholders, int placeholdersPerClause) {
        StringBuilder clausule = new StringBuilder(4 * totalPlaceholders);
        int clauseNumber = totalPlaceholders / placeholdersPerClause + 1;
        clausule.append(" (");
        int j = 0;
        for (int i = 0; i < clauseNumber; ++i) {
            clausule.append(fieldName).append(" IN (");
            int jFin = (i + 1) * placeholdersPerClause;
            while (j < jFin && j < totalPlaceholders) {
                clausule.append("?,");
                ++j;
            }
            clausule.setLength(clausule.length() - 1);
            clausule.append(")");
            if (i >= clauseNumber - 1) continue;
            clausule.append(" OR ");
        }
        clausule.append(") ");
        return clausule.toString();
    }

    public static String buildINClauseByValues(String fieldName, Collection values, int valuesPerClause) {
        StringBuffer inBuff = new StringBuffer();
        inBuff.append("(").append(fieldName).append(" IN (");
        int i = 1;
        for (Object value : values) {
            if (i > valuesPerClause - 1 && i % valuesPerClause == 0) {
                inBuff.append(") OR ").append(fieldName).append(" IN (");
            } else if (i > 1) {
                inBuff.append(", ");
            }
            inBuff.append(value);
            ++i;
        }
        inBuff.append("))");
        return inBuff.toString();
    }

    public static String buildINClauseByValues(String fieldName, Collection values) {
        return SQLUtils.buildINClauseByValues(fieldName, values, 1000);
    }
}

