/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ResourceLock
implements Serializable {
    private static final Map lockedRes = new HashMap();

    public static LockHandle getLock(String resourceId) {
        return ResourceLock.getLock(resourceId, 0L, true);
    }

    public static LockHandle getLock(String resourceId, boolean waitFor) {
        return ResourceLock.getLock(resourceId, 0L, waitFor);
    }

    public static LockHandle getLock(String resourceId, long timeout) {
        return ResourceLock.getLock(resourceId, timeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LockHandle getLock(String resourceId, long timeout, boolean waitFor) {
        try {
            LockHandle lk = null;
            Map map = lockedRes;
            synchronized (map) {
                while (lockedRes.containsKey(resourceId)) {
                    if (!waitFor) {
                        return null;
                    }
                    lockedRes.wait(timeout);
                }
                lk = new LockHandle(resourceId);
                lockedRes.put(resourceId, lk);
            }
            return lk;
        }
        catch (Exception e) {
            IllegalStateException error = new IllegalStateException(e.getMessage());
            error.initCause(e);
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getLockedResourceskeys() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        HashMap iterateMap = new HashMap();
        Map map = lockedRes;
        synchronized (map) {
            iterateMap.putAll(lockedRes);
            lockedRes.notifyAll();
        }
        for (String key : iterateMap.keySet()) {
            res.put(key, null);
        }
        return res;
    }

    public static class LockHandle
    implements Serializable {
        String resourceId;
        String callerStackTrace;

        LockHandle(String resourceId) {
            this.resourceId = resourceId;
            Exception e = new Exception();
            ByteArrayOutputStream bout = new ByteArrayOutputStream(512);
            PrintStream ps = new PrintStream(bout);
            e.printStackTrace(ps);
            ps.flush();
            this.callerStackTrace = bout.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            Map map = lockedRes;
            synchronized (map) {
                lockedRes.remove(this.resourceId);
                lockedRes.notifyAll();
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("ResourceLock id = ").append(this.resourceId).append("\nCalling Stack:\n").append(this.callerStackTrace);
            return buf.toString();
        }
    }
}

