/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class RemoteEJBProxy
implements Serializable {
    public static Object build(Class delegateInterface, Object targetInstance) {
        return Proxy.newProxyInstance(delegateInterface.getClassLoader(), new Class[]{delegateInterface}, (InvocationHandler)new InvocationHandlerImpl(targetInstance));
    }

    private static class InvocationHandlerImpl
    implements InvocationHandler,
    Serializable {
        private transient Object targetInstance;
        private Object handle;

        public InvocationHandlerImpl(Object targetInstance) {
            try {
                this.targetInstance = targetInstance;
                Method getHandleMethod = targetInstance.getClass().getMethod("getHandle", null);
                this.handle = getHandleMethod.invoke(targetInstance, null);
            }
            catch (Exception e) {
                IllegalArgumentException error = new IllegalArgumentException();
                error.initCause(e);
                throw error;
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.invokeSyncronized(method, args);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Object invokeSyncronized(Method method, Object[] params) throws Exception {
            if (this.targetInstance == null) {
                Method getEjbMethod = this.handle.getClass().getMethod("getEJBObject", null);
                this.targetInstance = getEjbMethod.invoke(this.handle, null);
            }
            Object object = this.targetInstance;
            synchronized (object) {
                try {
                    Object object2 = method.invoke(this.targetInstance, params);
                    return object2;
                }
                catch (Exception e) {
                    if (e instanceof InvocationTargetException) {
                        e = (Exception)e.getCause();
                    }
                    throw e;
                }
                finally {
                    this.targetInstance.notifyAll();
                }
            }
        }
    }
}

