/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ReflectUtils {
    public static Field[] getAllFieldsAsArray(Class classToReflect) {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Class clazz = classToReflect; clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                fields[i].setAccessible(true);
                list.add(fields[i]);
            }
        }
        return list.toArray(new Field[0]);
    }

    public static Collection getAllFieldsAsCollection(Class classToReflect) {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Class clazz = classToReflect; clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                fields[i].setAccessible(true);
                list.add(fields[i]);
            }
        }
        return list;
    }

    public static Map getAllFieldsAsMap(Class classToReflect) {
        HashMap<String, Field> map = new HashMap<String, Field>();
        for (Class clazz = classToReflect; clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                fields[i].setAccessible(true);
                map.put(fields[i].getName(), fields[i]);
            }
        }
        return map;
    }

    public static Map buildMapFromCollection(Collection c, Class itemType, String getKeyMethodName) throws Exception {
        HashMap result = new HashMap();
        Method getKeyMethod = itemType.getDeclaredMethod(getKeyMethodName, null);
        for (Object item : c) {
            Object key = getKeyMethod.invoke(item, null);
            result.put(key, item);
        }
        return result;
    }

    public static Map buildMapFromCollection(Collection c, KeyBuilder keyBuilder) throws Exception {
        return ReflectUtils.buildMapFromCollection(c, keyBuilder, HashMap.class);
    }

    public static Map buildMapFromCollection(Collection c, KeyBuilder keyBuilder, Class mapClass) throws Exception {
        Map result = (Map)mapClass.getConstructor(new Class[0]).newInstance(null);
        for (Object item : c) {
            Object key = keyBuilder.build(item);
            result.put(key, item);
        }
        return result;
    }

    public static String fieldsIterator(Object target, Class targetClass, String fieldNames, FieldIterator fieldIterator) throws Exception {
        Collection fields = ReflectUtils.getAllFieldsAsCollection(targetClass);
        boolean allFields = "*".equals(fieldNames);
        for (Field field : fields) {
            if (!allFields && fieldNames.indexOf(field.getName()) == -1 || !fieldIterator.nextField(field.getName(), field.get(target))) continue;
            return field.getName();
        }
        return null;
    }

    public static Object invokeSuperPrivateMethod(String name, Object targetObj, Object[] params) throws Exception {
        Method mm = null;
        Method[] m = targetObj.getClass().getSuperclass().getDeclaredMethods();
        for (int i = 0; i < m.length; ++i) {
            if (!m[i].getName().equals(name)) continue;
            mm = m[i];
            mm.setAccessible(true);
            break;
        }
        if (mm != null) {
            return mm.invoke(targetObj, params);
        }
        throw new IllegalStateException("Metodo n\u00e3o encontrado: " + name);
    }

    public static Object getSuperPrivateAttribute(String name, Object targetObj) throws Exception {
        Field m = targetObj.getClass().getSuperclass().getDeclaredField(name);
        m.setAccessible(true);
        return m.get(targetObj);
    }

    public static interface KeyBuilder {
        public Object build(Object var1);
    }

    public static interface FieldIterator {
        public boolean nextField(String var1, Object var2);
    }
}

