/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import com.sankhya.util.Data;
import com.sankhya.util.SimpleCollator;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class ReflectSorter
implements Comparator,
Serializable {
    private transient Field[] sortingFields;
    private int direction;
    private String criteria;
    private Class clazz;
    private SimpleCollator stringCollator;
    public static final int ASCEND = 1;
    public static final int DESCEND = 2;

    public ReflectSorter(Class clazz, String criteria, int direction) {
        this.clazz = clazz;
        this.criteria = criteria;
        this.direction = direction;
        this.compileDependences();
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public void setCriteria(String criteria) {
        this.criteria = criteria;
        this.compileDependences();
    }

    private void compileDependences() {
        if (this.clazz == null || this.criteria == null || this.criteria.length() == 0 || this.direction != 1 && this.direction != 2) {
            throw new IllegalArgumentException("Parametros para ReflectSorter inv\u00e1lidos,nulos ou vazios.");
        }
        String currentField = null;
        try {
            StringTokenizer tok = new StringTokenizer(this.criteria, ",");
            int criteriaSize = tok.countTokens();
            this.sortingFields = new Field[criteriaSize];
            for (int i = 0; i < criteriaSize; ++i) {
                currentField = tok.nextToken();
                this.sortingFields[i] = this.clazz.getDeclaredField(currentField);
                this.sortingFields[i].setAccessible(true);
            }
            this.stringCollator = new SimpleCollator();
        }
        catch (NoSuchFieldException e) {
            this.sortingFields = null;
            throw new IllegalArgumentException("Erro no crit\u00e9rio de ordena\u00e7\u00e3o, campo '" + currentField + "' n\u00e3o existe");
        }
    }

    public void sort(List toSort) {
        if (this.sortingFields == null || this.stringCollator == null) {
            this.compileDependences();
        }
        Collections.sort(toSort, this);
    }

    public static void main(String[] args) {
        try {
            Data item1 = new Data();
            item1.big = new BigDecimal(5);
            item1.date = new Date();
            item1.str = new String("CLAUDIA");
            Data item2 = new Data();
            item2.big = new BigDecimal(7);
            item2.date = new Date();
            item2.str = new String("CLAUDIa");
            Data item3 = new Data();
            item3.big = new BigDecimal(2);
            item3.date = new Date();
            item3.str = new String("ANA MARIA");
            Data item4 = new Data();
            item4.big = new BigDecimal(3);
            item4.date = new Date();
            item4.str = new String("ANA MARIA");
            ArrayList<Data> list = new ArrayList<Data>();
            list.add(item1);
            list.add(item2);
            list.add(item3);
            list.add(item4);
            ReflectSorter sorter = new ReflectSorter(Data.class, "str,big", 1);
            sorter.sort(list);
            Iterator ite = list.iterator();
            while (ite.hasNext()) {
                System.out.println(ite.next());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int compare(Object o1, Object o2) {
        Object objB;
        Object objA;
        if (this.direction == 1) {
            objA = o1;
            objB = o2;
        } else {
            objA = o2;
            objB = o1;
        }
        int result = 0;
        try {
            for (int i = 0; i < this.sortingFields.length && result == 0; ++i) {
                Field field = this.sortingFields[i];
                Object fieldA = field.get(objA);
                Object fieldB = field.get(objB);
                if (fieldA == null) {
                    if (fieldB == null) {
                        result = 0;
                        continue;
                    }
                    result = -1;
                    continue;
                }
                if (fieldB == null) {
                    if (fieldA == null) {
                        result = 0;
                        continue;
                    }
                    result = 1;
                    continue;
                }
                result = fieldA instanceof String ? this.stringCollator.compare(((String)fieldA).toUpperCase(), ((String)fieldB).toUpperCase()) : ((Comparable)fieldA).compareTo(fieldB);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Tipo diferente do declarado.");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Campo do crit\u00e9rio de ordena\u00e7\u00e3o inacess\u00edvel.");
        }
        return result;
    }
}

