/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import com.sankhya.util.Base64Impl;
import com.sankhya.util.StringUtils;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;

public class PasswordFormat {
    private static final char[] charSenha = new char[]{'1', '2', '3', '4', '5', 'B', 'C', 'D', 'E', 'F', 'L', 'M', 'N', 'O', 'P', 'G', 'H', 'I', 'J', 'K', 'Q', 'R', 'S', 'T', 'U', '6', '7', '8', '9', 'A', 'V', 'W', 'X', 'Y', 'Z', '!', '*', '&', '|', '$'};
    private static final int[] numSenha = new int[]{81, 42, 53, 65, 67, 21, 96, 43, 54, 66, 70, 95, 33, 44, 55, 61, 85, 23, 34, 45, 56, 62, 69, 94, 35, 46, 51, 71, 93, 91, 36, 41, 52, 64, 15, 88, 68, 50, 83, 40, 81};
    private static final int[] baralho = new int[]{5, 6, 11, 12, 3, 4, 15, 16, 7, 8, 13, 14, 1, 2, 17, 18, 9, 10, 19, 20};
    private static final int START_KEY = 981;
    private static final int MULT_KEY = 12674;
    private static final int ADD_KEY = 3891;

    public static String cryptSmtpPassword(String s) {
        return PasswordFormat.cryptSmtpPassword(s, true);
    }

    public static String cryptSmtpPassword(String s, boolean limitedSize) {
        int currentStartKey = 981;
        StringBuffer buf = new StringBuffer();
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                char newC = (char)(c ^ currentStartKey >> 8 & 0xFF);
                buf.append(newC);
                currentStartKey = (newC + currentStartKey) * 12674 + 3891;
            }
        }
        return PasswordFormat.convertStrToHex(buf.toString(), limitedSize);
    }

    private static String convertStrToHex(String str, boolean limitedSize) {
        String newStr = "";
        for (int i = 0; i < str.length(); ++i) {
            String s = Integer.toHexString(str.charAt(i));
            if (s.length() < 2) {
                s = "0" + s;
            }
            newStr = newStr + s;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(newStr);
        if (limitedSize) {
            int spaces = 30 - newStr.length();
            for (int i = 0; i < spaces; ++i) {
                buf.append(' ');
            }
        }
        buf.append("FF");
        return buf.toString();
    }

    public static String decryptSmtpPassword(String s) {
        return PasswordFormat.decryptSmtpPassword(s, true);
    }

    public static String decryptSmtpPassword(String s, boolean limitedSize) {
        if (limitedSize) {
            if (s.length() != 32) {
                throw new IllegalArgumentException("Formato de senha inv\u00e1lido.");
            }
            if (!"FF".equals(s.substring(30, 32).toUpperCase())) {
                throw new IllegalArgumentException("Formato de senha inv\u00e1lido.");
            }
        } else if (!"FF".equals(s.substring(s.length() - 2, s.length()).toUpperCase())) {
            throw new IllegalArgumentException("Formato de senha inv\u00e1lido.");
        }
        int currentStartKey = 981;
        StringBuffer buf = new StringBuffer();
        String decStr = null;
        decStr = limitedSize ? StringUtils.hexStr2decStr(s.substring(0, 30).trim()) : StringUtils.hexStr2decStr(s.substring(0, s.length() - 2).trim());
        for (int i = 0; i < decStr.length(); ++i) {
            char c = decStr.charAt(i);
            buf.append((char)(c ^ currentStartKey >> 8 & 0xFF));
            currentStartKey = (c + currentStartKey) * 12674 + 3891;
        }
        return buf.toString();
    }

    public static String format(String pass) {
        int i;
        if (pass == null) {
            pass = "";
        }
        StringBuffer newPass = new StringBuffer();
        StringBuffer finalPass = new StringBuffer();
        StringUtils buf = new StringUtils(pass);
        pass = buf.deleteChars('0').toString().toUpperCase();
        buf = null;
        while (pass.length() < 10) {
            pass = pass + " ";
        }
        for (i = 0; i < 10; ++i) {
            newPass.append(String.valueOf(PasswordFormat.procuraNumSenha(pass.charAt(i))));
        }
        for (i = 0; i < 20; ++i) {
            finalPass.append(newPass.charAt(baralho[i] - 1));
        }
        return PasswordFormat.numerosToSenha(finalPass.toString());
    }

    public static void main(String[] args) {
        String c = PasswordFormat.cryptSmtpPassword("a12345leandro91-234martins", false);
        System.out.println(c);
        String d = PasswordFormat.decryptSmtpPassword(c, false);
        System.out.println(d);
    }

    public static String createSkwAuth(String senhaSup) {
        StringBuilder stb = new StringBuilder();
        stb.append(senhaSup);
        stb.append(new SimpleDateFormat("ddMMyyyy").format(System.currentTimeMillis()));
        String auth = Base64Impl.encode(stb.toString().getBytes());
        auth = auth.trim();
        auth = auth.replaceAll("=", "%3D");
        auth = auth.replace("\n", "");
        return auth;
    }

    public static String unformat(String pass) {
        String numeros = PasswordFormat.senhaToNumeros(pass);
        String newPass = PasswordFormat.desembaralhar(numeros);
        return PasswordFormat.montaSenhaOriginal(newPass);
    }

    private static String desembaralhar(String pass) {
        StringBuffer buf = new StringBuffer();
        char[] chars = new char[20];
        for (int i = 0; i < 20; ++i) {
            chars[PasswordFormat.baralho[i] - 1] = pass.charAt(i);
        }
        return new String(chars);
    }

    private static String montaSenhaOriginal(String pass) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < 20; i += 2) {
            int numero = Integer.parseInt(pass.substring(i, i + 2));
            buf.append(PasswordFormat.procuraSenhaNum(numero));
        }
        return buf.toString().trim();
    }

    private static String numerosToSenha(String senha) {
        StringBuffer novaSenha = new StringBuffer();
        for (int i = 0; i < 20; i += 2) {
            int value = Integer.parseInt(senha.substring(i, i + 2));
            novaSenha.append(PasswordFormat.procuraCharSenha(value));
        }
        return novaSenha.toString();
    }

    private static char procuraCharSenha(int numero) {
        char result = '-';
        int index = -1;
        int size = numSenha.length;
        for (int i = 0; i < size; ++i) {
            if (numSenha[i] != numero) continue;
            index = i;
            break;
        }
        if (index > -1 && index < charSenha.length) {
            result = charSenha[index];
        }
        return result;
    }

    private static int procuraNumSenha(int c) {
        int retval = 99;
        int index = -1;
        int size = charSenha.length;
        for (int i = 0; i < size; ++i) {
            if (charSenha[i] != (char)c) continue;
            index = i;
            break;
        }
        if (index != -1) {
            retval = numSenha[index + 1];
        }
        return retval;
    }

    private static int procuraSenhaChar(char passChar) {
        int result = 99;
        int index = -1;
        int size = charSenha.length;
        for (int i = 0; i < size; ++i) {
            if (charSenha[i] != passChar) continue;
            index = i;
            break;
        }
        if (index > -1 && index < numSenha.length) {
            result = numSenha[index];
        }
        return result;
    }

    private static char procuraSenhaNum(int numero) {
        char retval = ' ';
        int index = -1;
        int size = numSenha.length;
        for (int i = 0; i < size; ++i) {
            if (numSenha[i] != numero) continue;
            index = i == 0 ? charSenha.length - 1 : i - 1;
            break;
        }
        if (index != -1) {
            retval = charSenha[index];
        }
        return retval;
    }

    private static String senhaToNumeros(String senha) {
        StringBuffer numeros = new StringBuffer();
        for (int i = 0; i < 10; ++i) {
            numeros.append(String.valueOf(PasswordFormat.procuraSenhaChar(senha.charAt(i))));
        }
        return numeros.toString();
    }

    public static String getSenhaHexMD5(String nomeusu, String senha) throws Exception {
        String nomeSenha = nomeusu.trim() + (senha != null ? senha.trim() : "");
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] senhaMD5 = md.digest(nomeSenha.getBytes("ISO-8859-1"));
        return StringUtils.toHexString(senhaMD5);
    }
}

