/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import com.sankhya.util.Base64Impl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;

public class ObjectSerializer {
    public static Object cloneObject(Object o) throws Exception {
        OpenedByteArrayOutputStream out = new OpenedByteArrayOutputStream(512);
        ObjectOutputStream oout = new ObjectOutputStream(out);
        oout.writeObject(o);
        oout.flush();
        oout.close();
        ObjectInputStream oin = new ObjectInputStream(out.buildInputStream());
        return oin.readObject();
    }

    public static Object deSerializeObject(String string) throws Exception {
        byte[] decodedBytes = Base64Impl.decode(string);
        Object result = null;
        if (decodedBytes != null && decodedBytes.length > 0) {
            ByteArrayInputStream in = new ByteArrayInputStream(decodedBytes);
            ObjectInputStream oin = new ObjectInputStream(in);
            result = oin.readObject();
        }
        return result;
    }

    public static Object deSerializeObject(String string, ClassLoader loader) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(Base64Impl.decode(string));
        Class<?> oinClass = Class.forName("java.io.ObjectInputStream", true, loader);
        Constructor<?> c = oinClass.getConstructor(InputStream.class);
        ObjectInputStream oin = (ObjectInputStream)c.newInstance(in);
        return oin.readObject();
    }

    public static byte[] getByteArray(Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        oos.flush();
        oos.close();
        baos.close();
        return baos.toByteArray();
    }

    public static void main(String[] args) {
        try {
            Object o = ObjectSerializer.deSerializeObject("rO0ABXNyABRqYXZhLm1hdGguQmlnRGVjaW1hbFTHFVf5gShPAgACSQAFc2NhbGVMAAZpbnRWYWx0\r\nABZMamF2YS9tYXRoL0JpZ0ludGVnZXI7eHIAEGphdmEubGFuZy5OdW1iZXKGrJUdC5TgiwIAAHhw\r\nAAAAAHNyABRqYXZhLm1hdGguQmlnSW50ZWdlcoz8nx+pO/sdAwAGSQAIYml0Q291bnRJAAliaXRM\r\nZW5ndGhJABNmaXJzdE5vbnplcm9CeXRlTnVtSQAMbG93ZXN0U2V0Qml0SQAGc2lnbnVtWwAJbWFn\r\nbml0dWRldAACW0J4cQB+AAL///////////////7////+AAAAAXVyAAJbQqzzF/gGCFTgAgAAeHAA\r\nAAABCXg=\r\n");
            System.out.println(o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String serializeObject(Object toSerialize) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        ObjectOutputStream oout = new ObjectOutputStream(out);
        oout.writeObject(toSerialize);
        oout.flush();
        oout.close();
        return Base64Impl.encode(out.toByteArray());
    }

    public Object deSerialize(String string) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(Base64Impl.decode(string));
        ObjectInputStream oin = new ObjectInputStream(in);
        return oin.readObject();
    }

    public String serialize(Object toSerialize) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        ObjectOutputStream oout = new ObjectOutputStream(out);
        oout.writeObject(toSerialize);
        oout.flush();
        oout.close();
        return Base64Impl.encode(out.toByteArray());
    }

    private static class OpenedByteArrayOutputStream
    extends ByteArrayOutputStream {
        public OpenedByteArrayOutputStream(int size) {
            super(size);
        }

        public ByteArrayInputStream buildInputStream() {
            return new ByteArrayInputStream(this.buf, 0, this.count);
        }
    }
}

