/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import com.sankhya.util.SimpleCollator;
import com.sankhya.util.SimpleData;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class ListSorter
implements Comparator,
Serializable {
    private DataSource dataSource;
    private SimpleCollator stringCollator;
    private String criteria;
    private String[] sortingFields;
    private int direction;
    public static final int ASCEND = 1;
    public static final int DESCEND = 2;
    private boolean nullGreater;

    public ListSorter(String criteria, int direction) {
        this.criteria = criteria;
        this.direction = direction;
        this.compileDependences();
    }

    public void setCriteria(String criteria) {
        this.criteria = criteria;
        this.compileDependences();
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public static void main(String[] args) {
        try {
            SimpleData item1 = new SimpleData();
            item1.big = new BigDecimal(5);
            item1.date = new Date();
            item1.str = null;
            SimpleData item2 = new SimpleData();
            item2.big = new BigDecimal(7);
            item2.date = new Date();
            item2.str = new String("SANTANA DAS DORES E BLA");
            SimpleData item3 = new SimpleData();
            item3.big = new BigDecimal(2);
            item3.date = new Date();
            item3.str = new String("SANT\u00c0 MONICA");
            SimpleData item4 = new SimpleData();
            item4.big = new BigDecimal(3);
            item4.date = new Date();
            item4.str = new String("SANTA MARTA");
            SimpleData item5 = new SimpleData();
            item5.big = new BigDecimal(3);
            item5.date = new Date();
            item5.str = new String("SANTA TEREZINHA");
            ArrayList<SimpleData> list = new ArrayList<SimpleData>();
            list.add(item1);
            list.add(item2);
            list.add(item3);
            list.add(item4);
            list.add(item5);
            ListSorter sorter = new ListSorter("str,date", 1);
            sorter.setDataSource(new DataSource(){

                @Override
                public Object getPropertyValue(String name, Object targetObject) {
                    try {
                        Field field = SimpleData.class.getField(name);
                        field.setAccessible(true);
                        return field.get(targetObject);
                    }
                    catch (Exception e) {
                        IllegalStateException error = new IllegalStateException();
                        error.initCause(e);
                        throw error;
                    }
                }
            });
            sorter.setNullGreater(true);
            sorter.sort(list);
            Iterator ite = list.iterator();
            while (ite.hasNext()) {
                System.out.println(ite.next());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int compare(Object o1, Object o2) {
        Object objB;
        Object objA;
        if (this.direction == 1) {
            objA = o1;
            objB = o2;
        } else {
            objA = o2;
            objB = o1;
        }
        int result = 0;
        try {
            for (int i = 0; i < this.sortingFields.length && result == 0; ++i) {
                Object fieldA = objA;
                Object fieldB = objB;
                if (this.dataSource != null) {
                    fieldA = this.dataSource.getPropertyValue(this.sortingFields[i], objA);
                    fieldB = this.dataSource.getPropertyValue(this.sortingFields[i], objB);
                }
                if (fieldA == null) {
                    if (fieldB == null) {
                        result = 0;
                        continue;
                    }
                    result = this.nullGreater ? 1 : -1;
                    continue;
                }
                if (fieldB == null) {
                    if (fieldA == null) {
                        result = 0;
                        continue;
                    }
                    result = this.nullGreater ? -1 : 1;
                    continue;
                }
                result = fieldA instanceof String ? this.stringCollator.compare(((String)fieldA).toUpperCase(), ((String)fieldB).toUpperCase()) : (fieldA.getClass().isArray() ? ListSorter.comparePrimitiveArrays(fieldA, fieldB) : ((Comparable)fieldA).compareTo(fieldB));
            }
        }
        catch (IllegalArgumentException e) {
            IllegalArgumentException error = new IllegalArgumentException("Tipo diferente do declarado.");
            error.initCause(e);
            throw error;
        }
        return result;
    }

    private static int comparePrimitiveArrays(Object a, Object b) {
        int minSize = Math.min(Array.getLength(a), Array.getLength(b));
        for (int i = 0; i < minSize; ++i) {
            int result = ((Comparable)Array.get(a, i)).compareTo(Array.get(b, i));
            if (result == 0) continue;
            return result;
        }
        return Array.getLength(a) - Array.getLength(b);
    }

    public void sort(List toSort) {
        if (this.sortingFields == null || this.stringCollator == null) {
            this.compileDependences();
        }
        Collections.sort(toSort, this);
    }

    private void compileDependences() {
        if (this.criteria == null || this.criteria.length() == 0 || this.direction != 1 && this.direction != 2) {
            throw new IllegalArgumentException("Parametros para ListSorter inv\u00e1lidos,nulos ou vazios.");
        }
        StringTokenizer tok = new StringTokenizer(this.criteria, ",");
        int criteriaSize = tok.countTokens();
        this.sortingFields = new String[criteriaSize];
        for (int i = 0; i < criteriaSize; ++i) {
            this.sortingFields[i] = tok.nextToken();
        }
        try {
            this.stringCollator = new SimpleCollator();
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
    }

    public void setNullGreater(boolean b) {
        this.nullGreater = b;
    }

    public static interface DataSource
    extends Serializable {
        public Object getPropertyValue(String var1, Object var2);
    }
}

