/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import br.com.sankhya.jasperfuncs.Funcoes;
import com.sankhya.util.StringUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public class JdbcUtils {
    private JdbcUtils() {
    }

    public static Connection buildConnectionFromProperties(Properties dbProperties) throws Exception {
        String vendor = dbProperties.getProperty("br.com.sankhya.database.vendor");
        String host = dbProperties.getProperty("br.com.sankhya.database.host");
        String port = dbProperties.getProperty("br.com.sankhya.database.port");
        String servico = dbProperties.getProperty("br.com.sankhya.database.servico");
        String user = dbProperties.getProperty("br.com.sankhya.database.user");
        String password = dbProperties.getProperty("br.com.sankhya.database.password");
        Connection conn = null;
        if ("oracle".equals(vendor)) {
            conn = Funcoes.conectarOracle(host, port, servico, user, password);
        } else if ("sqlserver".equals(vendor)) {
            String databasename = dbProperties.getProperty("br.com.sankhya.test.database.name");
            conn = StringUtils.isEmpty(servico) ? Funcoes.conectarSqlServer(host, port, databasename, user, password) : Funcoes.conectarSqlServer(host, port, servico, databasename, user, password);
        } else {
            throw new Exception("N\u00e3o foi poss\u00edvel identificar o tipo do banco de dados, verifique a propriedade 'br.com.sankhya.test.database.vendor'");
        }
        return conn;
    }

    public static void closeResultSet(ResultSet rset) {
        if (rset != null) {
            try {
                rset.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeStatement(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void fillMapFromResultSet(Map<String, Object> map, ResultSet rset) throws SQLException {
        ResultSetMetaData metadata = rset.getMetaData();
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            String columnName = metadata.getColumnName(i);
            Object value = JdbcUtils.getTypedFieldFromResultSet(columnName, rset);
            map.put(columnName, value);
        }
    }

    private static Object getTypedFieldFromResultSet(String fieldName, ResultSet rset) throws SQLException {
        Object value = rset.getObject(fieldName);
        if (value == null) {
            return null;
        }
        return JdbcUtils.getTypedFieldFromResultSet(fieldName, value.getClass(), rset);
    }

    public static Object getTypedFieldFromResultSet(String fieldName, Class<?> valueClass, ResultSet rset) throws SQLException {
        if (Number.class.isAssignableFrom(valueClass)) {
            return rset.getBigDecimal(fieldName);
        }
        if (Date.class.isAssignableFrom(valueClass) || java.sql.Date.class.isAssignableFrom(valueClass)) {
            return rset.getTimestamp(fieldName);
        }
        if (valueClass == String.class) {
            return rset.getString(fieldName);
        }
        return rset.getObject(fieldName);
    }
}

