/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import com.sankhya.util.Finder;
import com.sankhya.util.FinderMap;
import com.sankhya.util.FinderParam;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class FindersCollection
extends DefaultHandler {
    private HashMap map = new HashMap();
    private FinderMap currentBean;
    private Finder currentFinder;
    private String currentBeanName;
    private static FindersCollection shared = null;
    private static String BEAN_TAG = "bean";
    private static String FINDER_TAG = "finder";
    private static String PARAM_TAG = "param";

    private FindersCollection(InputStream source) throws Exception {
        System.out.println("" + (source == null));
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser saxParser = spf.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setContentHandler(this);
        xmlReader.setErrorHandler(this);
        InputSource inSource = new InputSource(source);
        xmlReader.parse(inSource);
    }

    @Override
    public synchronized void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals(BEAN_TAG)) {
            this.currentBeanName = atts.getValue("name");
            this.currentBean = new FinderMap(this.currentBeanName, atts.getValue("title"));
            this.map.put(this.currentBeanName, this.currentBean);
        } else if (qName.equals(FINDER_TAG)) {
            Finder finder = new Finder(atts.getValue("column"), atts.getValue("description"), atts.getValue("where"));
            finder.setBeanName(this.currentBeanName);
            String isDefault = atts.getValue("default");
            if (isDefault != null && isDefault.compareToIgnoreCase("true") == 0) {
                finder.makeDefault();
            }
            this.currentBean.put(finder.getColumnName(), finder);
            this.currentFinder = finder;
        } else if (qName.equals(PARAM_TAG)) {
            FinderParam param = new FinderParam(atts.getValue("type"), atts.getValue("name"), Boolean.valueOf(atts.getValue("upper")));
            this.currentFinder.addParameter(param);
        }
    }

    public FinderMap getFinders(String beanName) {
        return (FinderMap)this.map.get(beanName);
    }

    public static void initShared(InputStream in) throws Exception {
        shared = new FindersCollection(in);
    }

    public static FindersCollection getSharedInstance() {
        return shared;
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            System.out.println("falta o nome do arquivo XML");
            return;
        }
        try {
            FileInputStream in = new FileInputStream(args[0]);
            FindersCollection.initShared(in);
            FindersCollection finders = FindersCollection.getSharedInstance();
            FinderMap c = finders.getFinders("Parceiro");
            System.out.println(c.getTitle());
            Iterator ite = c.keySet().iterator();
            while (ite.hasNext()) {
                Finder finder = (Finder)c.get(ite.next());
                if (finder.getColumnName().equals("CODPARC")) {
                    Object[] ret = finder.prepareParameters(new String[]{"123"});
                    System.out.println(ret[0].getClass().getName());
                    System.out.println(ret[0]);
                }
                System.out.println(finder);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

