/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import com.sankhya.util.FinderParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;

public class Finder
implements Serializable {
    private String beanName;
    private String columnName;
    private String description;
    private String where;
    private ArrayList paramList = new ArrayList();
    private boolean isDefault;
    private static DateFormat format = DateFormat.getDateInstance();

    public Finder(String columnName, String description, String where) {
        this.columnName = columnName;
        this.description = description;
        this.where = where;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getDescription() {
        return this.description;
    }

    public void makeDefault() {
        this.isDefault = true;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String toString() {
        return "columnName=" + this.columnName + ",descriptor=" + this.description + ",isDefault=" + this.isDefault + ",where=" + this.where;
    }

    public void addParameter(FinderParam param) {
        this.paramList.add(param);
    }

    public ArrayList getParameters() {
        return this.paramList;
    }

    public String getWhereString() {
        return this.where;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] prepareParameters(String[] values) throws IllegalArgumentException {
        Object[] ret = new Object[values.length];
        Object item = null;
        try {
            for (int i = 0; i < values.length; ++i) {
                FinderParam param = (FinderParam)this.paramList.get(i);
                if (param.getType().equals("String")) {
                    item = values[i];
                    if (item != null && param.isUpper()) {
                        item = ((String)item).toUpperCase();
                    }
                } else if (param.getType().equals("BigDecimal")) {
                    item = new BigDecimal(values[i]);
                } else if (param.getType().equals("Date")) {
                    DateFormat dateFormat = format;
                    synchronized (dateFormat) {
                        item = format.parse(values[i]);
                    }
                }
                ret[i] = item;
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Tipo de dado incompativel com pesquisa.");
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Tipo de dado incompativel com pesquisa.");
        }
        return ret;
    }

    public int getParamSize() {
        return this.paramList.size();
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String string) {
        this.beanName = string;
    }
}

