/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

public class FileAndStreamUtils {
    private static final int DEFAUL_BLOCK_SIZE = 256;

    private FileAndStreamUtils() {
    }

    public static String readStringFromStream(InputStream inputStream, String charsetName) throws IOException {
        InputStreamReader reader = new InputStreamReader(inputStream, Charset.forName(charsetName));
        return FileAndStreamUtils.readStringFromReader(reader);
    }

    public static String readStringFromStream(InputStream inputStream) throws IOException {
        InputStreamReader reader = new InputStreamReader(inputStream);
        return FileAndStreamUtils.readStringFromReader(reader);
    }

    public static String readStringFromFile(String fileName) throws IOException {
        File file = new File(fileName);
        return FileAndStreamUtils.readStringFromFile(file);
    }

    public static String readStringFromFile(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        return FileAndStreamUtils.readStringFromReader(fileReader);
    }

    public static String readStringFromReader(Reader reader) throws IOException {
        return FileAndStreamUtils.readStringFromReader(reader, 256);
    }

    private static String readStringFromReader(Reader reader, int blockSize) throws IOException {
        StringBuffer readString = new StringBuffer(blockSize);
        char[] charBuf = new char[blockSize];
        int readChars = 0;
        while ((readChars = reader.read(charBuf)) > 0) {
            readString.append(charBuf, 0, readChars);
        }
        reader.close();
        return readString.toString().trim();
    }

    public static Object readObjectFromFile(File file) throws IOException, ClassNotFoundException {
        FileInputStream inputStream = new FileInputStream(file);
        ObjectInputStream objectInput = new ObjectInputStream(inputStream);
        Object readObject = objectInput.readObject();
        objectInput.close();
        return readObject;
    }

    public static void writeStringToFile(String content, String filename) throws IOException {
        FileWriter fileWriter = new FileWriter(filename);
        fileWriter.write(content);
        ((Writer)fileWriter).close();
    }
}

