/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import com.sankhya.util.StringFormat;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FieldInfo
implements Serializable {
    private String name;
    private String label;
    private String type;
    private String mask;
    private String formvariable;
    private String attribImg;
    private String attribTd;
    private static DecimalFormat numFormater = new DecimalFormat();
    private static SimpleDateFormat datFormater = new SimpleDateFormat();
    private static StringFormat stringFormater = new StringFormat();

    public FieldInfo(String name, String label, String type, String mask, String formvariable, String attribImg, String attribTd) {
        this.name = name;
        this.label = label;
        this.type = type;
        this.mask = mask;
        this.formvariable = formvariable;
        this.attribImg = attribImg;
        this.attribTd = attribTd;
    }

    public String toString() {
        return "name=" + this.name + ",label=" + this.label + ",type=" + this.type + ",mask=" + this.mask + ",formvariable=" + this.formvariable + ",attribImg=" + this.attribImg + ",attribTd=" + this.attribTd;
    }

    public String getLabel() {
        return this.label;
    }

    public String getMask() {
        return this.mask;
    }

    public String getName() {
        return this.name;
    }

    public String getFormVariable() {
        return this.formvariable;
    }

    public String getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatValue(Object value) {
        String result = null;
        if (value == null) {
            return "";
        }
        if (this.mask == null || this.mask.length() == 0) {
            return value.toString();
        }
        if (this.type.equals("Date")) {
            SimpleDateFormat simpleDateFormat = datFormater;
            synchronized (simpleDateFormat) {
                datFormater.applyPattern(this.mask);
                result = datFormater.format((Date)value);
            }
        }
        if (this.type.equals("BigDecimal")) {
            DecimalFormat decimalFormat = numFormater;
            synchronized (decimalFormat) {
                numFormater.applyPattern(this.mask);
                result = numFormater.format(value);
            }
        }
        if (this.type.equals("String")) {
            StringFormat stringFormat = stringFormater;
            synchronized (stringFormat) {
                try {
                    stringFormater.setPattern(this.mask);
                    result = stringFormater.format(value.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result = value.toString();
                }
            }
        }
        return result;
    }

    public String getAttribImg() {
        return this.attribImg;
    }

    public String getAttribTd() {
        return this.attribTd;
    }
}

