/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import java.io.Serializable;
import java.util.Stack;

public class ExceptionIterator
implements Serializable {
    public static Throwable iterate(Throwable excp, CauseIterator iterator) {
        Stack<Throwable> causeStack = new Stack<Throwable>();
        causeStack.push(excp);
        Throwable cause = null;
        Throwable currentError = excp;
        while ((cause = currentError.getCause()) != null) {
            causeStack.push(cause);
            currentError = cause;
        }
        while (!causeStack.isEmpty()) {
            cause = (Throwable)causeStack.pop();
            if (!iterator.onNextCause(cause)) continue;
            return cause;
        }
        return excp;
    }

    public static boolean isCausedBy(Throwable e, final Class lookFor) {
        Throwable cause = ExceptionIterator.iterate(e, new CauseIterator(){

            @Override
            public boolean onNextCause(Throwable t) {
                return lookFor.isAssignableFrom(t.getClass());
            }
        });
        return lookFor.isAssignableFrom(cause.getClass());
    }

    public void m1() throws Exception {
        try {
            this.m2();
        }
        catch (Exception e) {
            Exception error = new Exception();
            error.initCause(e);
            throw error;
        }
    }

    public void m2() throws Exception {
        try {
            this.m3();
        }
        catch (Exception e) {
            Exception error = new Exception("Teste de erro");
            error.initCause(e);
            throw error;
        }
    }

    public void m3() throws Exception {
        throw new IllegalArgumentException();
    }

    public static void main(String[] args) {
        ExceptionIterator ite = new ExceptionIterator();
        try {
            ite.m1();
        }
        catch (Exception e) {
            ExceptionIterator.iterate(e, new CauseIterator(){

                @Override
                public boolean onNextCause(Throwable cause) {
                    System.out.println(cause.getClass().getName());
                    System.out.println(cause.getMessage());
                    return false;
                }
            });
        }
    }

    public static interface CauseIterator {
        public boolean onNextCause(Throwable var1);
    }
}

