/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import com.sankhya.util.BigDecimalUtil;
import com.sankhya.util.Extenso;
import com.sankhya.util.StringFormat;
import com.sankhya.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class DanfeUtils {
    public static String formatTelefone(String telefone) {
        StringFormat telefoneFormat = new StringFormat();
        telefoneFormat.setPattern("###-####-####");
        return !StringUtils.isEmpty(telefone) ? telefoneFormat.format(telefone) : null;
    }

    public static String formatChaveNFe(String chaveNFe) {
        StringFormat chaveNFeFormat = new StringFormat();
        chaveNFeFormat.setPattern("#### #### #### #### #### #### #### #### #### #### ####");
        return !StringUtils.isEmpty(chaveNFe) ? chaveNFeFormat.format(chaveNFe) : null;
    }

    public static String formatCnpj(String cnpj) {
        return !StringUtils.isEmpty(cnpj) ? StringUtils.formataCgcCpf(cnpj) : null;
    }

    public static String formatCep(String cep) {
        StringFormat cepFormat = new StringFormat();
        cepFormat.setPattern("##.###-###");
        return !StringUtils.isEmpty(cep) ? cepFormat.format(cep) : null;
    }

    public static String formatNumeroNota(BigDecimal numeroNota) {
        DecimalFormat numeroNotaFormat = new DecimalFormat("###,##0");
        return numeroNota != null ? numeroNotaFormat.format(numeroNota) : null;
    }

    public static String getCurrency(BigDecimal value) {
        NumberFormat currencyFormat = NumberFormat.getCurrencyInstance(new Locale("pt", "BR"));
        return value != null ? currencyFormat.format(value) : null;
    }

    public static String getExtenso(BigDecimal value) {
        return Extenso.getExtenso(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFaturas(BigDecimal numeroNota, Connection dbConnection) throws SQLException {
        if (numeroNota == null) {
            throw new IllegalArgumentException("Numero da nota n\u00e3o pode ser nulo!");
        }
        Statement sqlStatement = null;
        ResultSet resultSet = null;
        try {
            StringBuffer sqlBuf = new StringBuffer(256);
            sqlBuf.append(" SELECT ");
            sqlBuf.append(" FIN.VLRDESDOB,");
            sqlBuf.append(" FIN.DTVENC,");
            sqlBuf.append(" FIN.NUMNOTA");
            sqlBuf.append(" FROM TGFFIN FIN");
            sqlBuf.append(" WHERE FIN.NUNOTA = ?");
            sqlBuf.append(" AND (FIN.DESDOBDUPL IS NULL OR FIN.DESDOBDUPL NOT IN ('F', 'K'))");
            sqlBuf.append(" ORDER BY FIN.DTVENC");
            sqlStatement = dbConnection.prepareStatement(sqlBuf.toString(), 1003, 1007);
            sqlStatement.setBigDecimal(1, numeroNota);
            resultSet = sqlStatement.executeQuery();
            int parcela = 1;
            StringBuffer fatura = new StringBuffer(256);
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            DecimalFormat currencyFormt = new DecimalFormat("#,##0.00");
            while (resultSet.next()) {
                if (fatura.length() > 0) {
                    fatura.append(" | ");
                }
                fatura.append(" Dup=" + StringUtils.stringZero(resultSet.getBigDecimal("NUMNOTA"), 9) + "-" + StringUtils.stringZero(parcela++, 2));
                fatura.append(" Venc=" + sdf.format(resultSet.getTimestamp("DTVENC")));
                fatura.append(" Valor=" + currencyFormt.format(resultSet.getDouble("VLRDESDOB")));
            }
            String string = fatura.toString();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (sqlStatement != null) {
                sqlStatement.close();
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProtocolo(BigDecimal numeroNota, Connection conn) throws SQLException {
        PreparedStatement pstm = null;
        try {
            pstm = conn.prepareStatement("SELECT * FROM TGFCAB WHERE NUNOTA = ?");
            pstm.setBigDecimal(1, numeroNota);
            ResultSet rset = pstm.executeQuery();
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            StringBuilder protocolo = new StringBuilder();
            if (rset.next()) {
                int tipoEmissao = rset.getInt("TPEMISNFE");
                Timestamp dhRecebimento = null;
                BigDecimal numero = null;
                switch (tipoEmissao) {
                    case 2: {
                        String string = DanfeUtils.gerarChaveContingencia(rset, conn);
                        return string;
                    }
                    case 4: {
                        numero = rset.getBigDecimal("NUMREGDPEC");
                        dhRecebimento = rset.getTimestamp("DHREGDPEC");
                        break;
                    }
                    default: {
                        numero = rset.getBigDecimal("NUMPROTOC");
                        dhRecebimento = rset.getTimestamp("DHPROTOC");
                    }
                }
                protocolo.append(numero);
                if (dhRecebimento != null) {
                    protocolo.append(" ").append(df.format(dhRecebimento));
                }
            }
            String string = protocolo.toString();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (pstm != null) {
                pstm.close();
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String gerarChaveContingencia(ResultSet rset, Connection conn) throws SQLException {
        StringBuilder chaveContingencia = new StringBuilder();
        String ufParceiro = null;
        String cgcCpf = null;
        Statement pstm = null;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT UF.CODIBGE, P.CGC_CPF ");
            sql.append(" FROM TGFPAR P");
            sql.append(" INNER JOIN TSICID C ON (P.CODCID = C.CODCID)");
            sql.append(" INNER JOIN TSIUFS UF ON (UF.CODUF = C.UF)");
            sql.append(" WHERE P.CODPARC = ?");
            pstm = conn.prepareStatement(sql.toString());
            BigDecimal codigoParceiro = rset.getBigDecimal("CODPARC");
            pstm.setBigDecimal(1, codigoParceiro);
            ResultSet rsetParc = pstm.executeQuery();
            if (rsetParc.next()) {
                BigDecimal codigoIbge = rsetParc.getBigDecimal("CODIBGE");
                ufParceiro = codigoIbge != null ? codigoIbge.toString() : "";
                cgcCpf = rsetParc.getString("CGC_CPF");
            }
        }
        finally {
            if (pstm != null) {
                pstm.close();
            }
        }
        chaveContingencia.append(StringUtils.stringZero(ufParceiro, 2));
        chaveContingencia.append("2");
        chaveContingencia.append(StringUtils.stringZero(cgcCpf, 14));
        DecimalFormat decFormat = new DecimalFormat("000000000000.00");
        String valor = decFormat.format(rset.getBigDecimal("VLRNOTA"));
        chaveContingencia.append(valor.replaceAll(",", ""));
        int icmsp = BigDecimalUtil.getValueOrZero(rset.getBigDecimal("BASEICMS")).doubleValue() == 0.0 ? 2 : 1;
        int icmss = BigDecimalUtil.getValueOrZero(rset.getBigDecimal("BASESUBSTIT")).doubleValue() == 0.0 ? 2 : 1;
        chaveContingencia.append(icmsp);
        chaveContingencia.append(icmss);
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd");
        chaveContingencia.append(dateFormat.format(rset.getTimestamp("DTNEG")));
        chaveContingencia.append(StringUtils.digitoVerificador(chaveContingencia.toString()));
        chaveContingencia.toString();
        StringFormat chaveNFeFormat = new StringFormat();
        chaveNFeFormat.setPattern("#### #### #### #### #### #### #### #### ####");
        return chaveNFeFormat.format(chaveContingencia.toString());
    }
}

