/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ComparationUtils {
    public static int compareSkwVersion(String version1, String version2) {
        Pattern regExp = Pattern.compile("((\\d+)\\.(\\d+)\\.(\\d+)|desenvolvimento)b(\\d+)");
        Matcher matchVersion1 = regExp.matcher(version1);
        Matcher matchVersion2 = regExp.matcher(version2);
        if (matchVersion1.matches() && matchVersion2.matches()) {
            String fullVersion1 = matchVersion1.group(1);
            String fullVersion2 = matchVersion2.group(1);
            String buildNumber1 = matchVersion1.group(5);
            String buildNumber2 = matchVersion2.group(5);
            boolean ehDesenvolvimento1 = "desenvolvimento".equals(fullVersion1);
            boolean ehDesenvolvimento2 = "desenvolvimento".equals(fullVersion2);
            Comparator<String> comp = new Comparator<String>(){

                @Override
                public int compare(String valor1, String valor2) {
                    int intValue1 = 0;
                    int intValue2 = 0;
                    if (valor1 != null) {
                        intValue1 = Integer.parseInt(valor1);
                    }
                    if (valor2 != null) {
                        intValue2 = Integer.parseInt(valor2);
                    }
                    return intValue1 - intValue2;
                }
            };
            int result = 0;
            if (ehDesenvolvimento1 && ehDesenvolvimento2) {
                result = comp.compare(buildNumber1, buildNumber2);
            } else if (ehDesenvolvimento1 && !ehDesenvolvimento2) {
                result = 1;
            } else if (!ehDesenvolvimento1 && ehDesenvolvimento2) {
                result = -1;
            } else {
                result = comp.compare(matchVersion1.group(2), matchVersion2.group(2));
                if (result == 0 && (result = comp.compare(matchVersion1.group(3), matchVersion2.group(3))) == 0 && (result = comp.compare(matchVersion1.group(4), matchVersion2.group(4))) == 0) {
                    result = comp.compare(buildNumber1, buildNumber2);
                }
            }
            return result;
        }
        throw new IllegalArgumentException("N\u00e3o \u00e9 poss\u00edvel comparar as vers\u00f5es '" + version1 + "' e '" + version2 + "'");
    }
}

