/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import java.util.ArrayList;
import java.util.Collection;
import org.jdom.Content;
import org.jdom.Element;

public class CheckList {
    private Collection<CheckListItem> items = new ArrayList<CheckListItem>();

    public void addItem(CheckListItem item) {
        this.items.add(item);
    }

    public void addItem(String description, String details, boolean checked) {
        this.items.add(new CheckListItem(description, details, checked));
    }

    public Element asXML() {
        Element checkListElement = new Element("checkList");
        for (CheckListItem checkListItem : this.items) {
            String details;
            Element itemElement = new Element("item");
            String description = checkListItem.getDescription();
            if (description != null) {
                itemElement.setAttribute("description", description);
            }
            if ((details = checkListItem.getDetails()) != null) {
                Element detailsElement = new Element("details");
                detailsElement.addContent(details);
                itemElement.addContent((Content)detailsElement);
            }
            itemElement.setAttribute("checked", Boolean.toString(checkListItem.checked));
            checkListElement.addContent((Content)itemElement);
        }
        return checkListElement;
    }

    public Collection<CheckListItem> getItems() {
        return this.items;
    }

    public void setItems(Collection<CheckListItem> items) {
        this.items = items;
    }

    public class CheckListItem {
        private String description;
        private String details;
        private boolean checked;

        public CheckListItem() {
        }

        public CheckListItem(String description, String details, boolean checked) {
            this.description = description;
            this.details = details;
            this.checked = checked;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDetails() {
            return this.details;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean checked) {
            this.checked = checked;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setDetails(String details) {
            this.details = details;
        }
    }
}

