/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class BigDecimalUtil {
    public static final BigDecimal ZERO_VALUE = new BigDecimal(0);
    public static final BigDecimal CEM_VALUE = BigDecimal.valueOf(100.0);
    public static final MathContext MATH_CTX = new MathContext(64, RoundingMode.HALF_UP);

    public static BigDecimal buildFromDouble(double d) {
        int asInt = (int)d;
        BigDecimal result = null;
        result = (double)asInt != d ? new BigDecimal(String.valueOf(d)) : new BigDecimal(asInt);
        return result;
    }

    public static BigDecimal buildFromDouble(Number d) {
        BigDecimal result = null;
        if (d != null) {
            double value = d.doubleValue();
            int asInt = (int)value;
            result = (double)asInt != value ? new BigDecimal(String.valueOf(value)) : new BigDecimal(asInt);
        }
        return result;
    }

    public static BigDecimal getRounded(double value, int scale) {
        return new BigDecimal(value).setScale(scale, 4);
    }

    public static BigDecimal getRounded(BigDecimal value, int scale) {
        return value.setScale(scale, 4);
    }

    public static double getRoundedDouble(double value, int scale) {
        BigDecimal b = new BigDecimal(String.valueOf(value)).setScale(scale, 4);
        return new Double(b.toString());
    }

    public static int getValue(BigDecimal value, int vlrDefault) {
        if (value == null) {
            return vlrDefault;
        }
        return value.intValue();
    }

    public static BigDecimal getValue(BigDecimal value, BigDecimal vlrDefault) {
        if (value == null) {
            return vlrDefault;
        }
        return value;
    }

    public static BigDecimal getValueOrZero(BigDecimal value) {
        if (value == null) {
            return ZERO_VALUE;
        }
        return value;
    }

    public static boolean isEmpty(BigDecimal value) {
        return value == null || value.intValue() == 0;
    }

    public static void main(String[] args) {
        BigDecimal b = new BigDecimal("190095.0566");
        System.out.println(BigDecimalUtil.formatCurrency(b, 3));
    }

    public static BigDecimal porcentagem(BigDecimal parte, BigDecimal todo) {
        MathContext mathCtx = new MathContext(2, RoundingMode.HALF_UP);
        return BigDecimalUtil.porcentagem(parte, todo, mathCtx);
    }

    public static BigDecimal porcentagem(BigDecimal parte, BigDecimal todo, MathContext mathCtx) {
        return parte.multiply(CEM_VALUE).divide(todo, mathCtx);
    }

    public static String toCurrency(BigDecimal value) {
        DecimalFormat currencyFormt = new DecimalFormat("#,##0.00");
        return value == null ? "" : currencyFormt.format(value);
    }

    public static BigDecimal truncate(BigDecimal value, int scale) {
        return value.setScale(scale, 1);
    }

    public static BigDecimal truncate(double value, int scale) {
        return BigDecimal.valueOf(value).setScale(scale, 1);
    }

    public static BigDecimal valueOf(double d) {
        return BigDecimal.valueOf(d);
    }

    public static BigDecimal valueOf(long l) {
        return BigDecimal.valueOf(l);
    }

    public static BigDecimal valueOf(String s) {
        return new BigDecimal(s);
    }

    public static BigDecimal max(BigDecimal a, BigDecimal b) {
        if (a.compareTo(b) > 0) {
            return a;
        }
        return b;
    }

    public static BigDecimal min(BigDecimal a, BigDecimal b) {
        if (a.compareTo(b) < 0) {
            return a;
        }
        return b;
    }

    public static double subtractDouble(double value1, double value2) {
        return BigDecimal.valueOf(value1).subtract(BigDecimal.valueOf(value2)).doubleValue();
    }

    public static String formatCurrency(BigDecimal value, int scale) {
        StringBuffer strFormat = new StringBuffer("#,##0");
        if (scale > 0) {
            strFormat.append(".");
        }
        for (int i = 0; i < scale; ++i) {
            strFormat.append("0");
        }
        DecimalFormat currencyFormt = new DecimalFormat(strFormat.toString());
        return value == null ? "" : currencyFormt.format(value);
    }
}

