/*
 * Decompiled with CFR 0.152.
 */
package com.sankhya.util;

import com.sankhya.util.FieldInfo;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class BeanMetaData
extends DefaultHandler {
    private HashMap map = new HashMap();
    private ArrayList currentBean;
    private String currentBeanName;
    private static BeanMetaData shared = null;
    private static String BEAN_TAG = "bean";
    private static String FIELD_TAG = "field";

    private BeanMetaData(InputStream source) throws Exception {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser saxParser = spf.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setContentHandler(this);
        xmlReader.setErrorHandler(this);
        InputSource inSource = new InputSource(source);
        xmlReader.parse(inSource);
    }

    @Override
    public synchronized void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals(BEAN_TAG)) {
            this.currentBean = new ArrayList();
            this.map.put(atts.getValue("name"), this.currentBean);
        } else if (qName.equals(FIELD_TAG)) {
            FieldInfo field = new FieldInfo(atts.getValue("name"), atts.getValue("label"), atts.getValue("type"), atts.getValue("mask"), atts.getValue("formvariable"), atts.getValue("attribimg"), atts.getValue("attribtd"));
            this.currentBean.add(field);
        }
    }

    public Collection getFields(String beanName) {
        return (Collection)this.map.get(beanName);
    }

    public static void initShared(InputStream in) throws Exception {
        shared = new BeanMetaData(in);
    }

    public static BeanMetaData getSharedInstance() {
        return shared;
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            System.out.println("falta o nome do arquivo XML");
            return;
        }
        try {
            FileInputStream in = new FileInputStream(args[0]);
            BeanMetaData.initShared(in);
            BeanMetaData meta = BeanMetaData.getSharedInstance();
            Collection c = meta.getFields("Parceiro");
            for (FieldInfo field : c) {
                System.out.println(field);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

