/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.jasperfuncs;

import com.sankhya.util.JdbcUtils;
import com.sankhya.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Funcoes {
    private static final int SQLSERVER_PORTAPADRAO = 1433;

    public static String pdes(Connection c, String sCol, String sTable, String sWhere) {
        String string;
        PreparedStatement pstm = null;
        try {
            StringBuffer sSQL = new StringBuffer();
            sSQL.append(" SELECT ");
            sSQL.append(sCol);
            sSQL.append(" FROM ");
            sSQL.append(sTable);
            sSQL.append(" WHERE ");
            sSQL.append(sWhere);
            pstm = c.prepareStatement(sSQL.toString(), 1003, 1007);
            pstm.setMaxRows(1);
            ResultSet rs = pstm.executeQuery();
            String result = "";
            if (rs.next()) {
                result = rs.getString(1);
            }
            string = result == null ? "" : result;
        }
        catch (Exception e) {
            try {
                IllegalArgumentException ie = new IllegalArgumentException();
                ie.initCause(e);
                throw ie;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(pstm);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(pstm);
        return string;
    }

    public static Connection conectarOracle(String ip, String numeroPorta, String servico, String usuario, String senha) {
        Funcoes.carregarDriver("oracle.jdbc.driver.OracleDriver");
        StringBuilder url = new StringBuilder();
        url.append("jdbc:oracle:thin:@").append(ip);
        url.append(":").append(numeroPorta);
        url.append(":").append(servico);
        return Funcoes.conectar(url.toString(), usuario, senha);
    }

    public static Connection conectarSqlServer(String ip, String numeroPorta, String nomeBanco, String usuario, String senha) {
        return Funcoes.conectarSqlServer(ip, numeroPorta, null, nomeBanco, usuario, senha);
    }

    public static Connection conectarSqlServer(String ip, String numeroPorta, String instancia, String nomeBanco, String usuario, String senha) {
        Funcoes.carregarDriver("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        StringBuilder url = new StringBuilder();
        url.append("jdbc:sqlserver://").append(ip);
        if (Integer.parseInt(numeroPorta) != 1433) {
            url.append(":").append(numeroPorta);
        }
        if (!StringUtils.isEmpty(instancia)) {
            url.append(";instanceName=").append(instancia);
        }
        url.append(";databaseName=").append(nomeBanco);
        url.append(";lastUpdateCount=true");
        return Funcoes.conectar(url.toString(), usuario, senha);
    }

    private static void carregarDriver(String driverName) {
        try {
            Class.forName(driverName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("N\u00e3o foi poss\u00edvel carregar o driver: " + driverName + ".\nVerifique se o arquivo est\u00e1 em seu classpath");
        }
    }

    private static Connection conectar(String url, String usuario, String senha) {
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(url, usuario, senha);
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("N\u00e3o foi poss\u00edvel conectar-se ao banco de dados. Verifique os dados da conex\u00e3o.", e);
        }
        return conn;
    }

    public static Object stp(Connection c, String name, Object[] inParams) throws Exception {
        return Funcoes.stp(c, name, inParams, 0);
    }

    public static Object stp(Connection c, String name) throws Exception {
        return Funcoes.stp(c, name, new Object[0], 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object stp(Connection c, String name, Object[] inParams, int outType) throws Exception {
        Statement cstmt = null;
        Object result = null;
        try {
            StringBuffer buf = new StringBuffer();
            buf.append("{call ").append(name).append("(");
            if (inParams.length > 0) {
                if (inParams.length % 2 > 0) {
                    throw new IllegalStateException("Parametros de entrada devem ser informados em pares de tipo e valor");
                }
                int paramCount = inParams.length / 2;
                for (int i = 0; i < paramCount; ++i) {
                    if (i > 0) {
                        buf.append(",");
                    }
                    buf.append("?");
                }
            }
            buf.append(")}");
            cstmt = c.prepareCall(buf.toString());
            int p = 1;
            if (inParams.length > 0) {
                int paramCount = inParams.length / 2;
                int i = 0;
                int j = 0;
                while (i < paramCount) {
                    String type = (String)inParams[j];
                    Object val = inParams[j + 1];
                    if ("T".equalsIgnoreCase(type)) {
                        if (val instanceof String) {
                            SimpleDateFormat sdf;
                            String s = (String)val;
                            if (s.length() == "99/99/9999".length()) {
                                sdf = new SimpleDateFormat("dd/MM/yyyy");
                                val = sdf.parse(s);
                            } else if (s.length() == "99/99/9999 99:99:99".length()) {
                                sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                                val = sdf.parse(s);
                            }
                        }
                        cstmt.setTimestamp(p, new Timestamp(((Date)val).getTime()));
                    } else if ("S".equalsIgnoreCase(type)) {
                        cstmt.setString(p, (String)val);
                    } else if ("N".equalsIgnoreCase(type)) {
                        cstmt.setBigDecimal(p, new BigDecimal(val.toString()));
                    }
                    ++p;
                    ++i;
                    j += 2;
                }
            }
            if (outType > 0) {
                cstmt.registerOutParameter(p, outType);
            }
            cstmt.execute();
            if (outType > 0) {
                result = cstmt.getObject(p);
            }
        }
        finally {
            if (cstmt != null) {
                cstmt.close();
            }
        }
        return result;
    }
}

