/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.colorpalette;

import com.sankhya.util.XMLUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class ColorPalette {
    private Collection<String[]> colors;
    private Iterator<String[]> colorIterator;
    private int toneIndex = 0;

    public ColorPalette() throws Exception {
        Document palettDoc = new SAXBuilder().build(this.getClass().getResourceAsStream("resources/DefaultPalette.xml"));
        this.loadPalett(palettDoc.getRootElement());
    }

    public ColorPalette(Element paletteElem) throws Exception {
        this.loadPalett(paletteElem);
    }

    private void loadPalett(Element paletteElem) throws Exception {
        this.colors = new ArrayList<String[]>();
        for (Element colorElem : paletteElem.getChildren("color")) {
            String mainColor = XMLUtils.getRequiredAttributeAsString(colorElem, "mainColor");
            String lightColor = XMLUtils.getRequiredAttributeAsString(colorElem, "lightColor");
            String darkColor = XMLUtils.getRequiredAttributeAsString(colorElem, "darkColor");
            String textColor = XMLUtils.getRequiredAttributeAsString(colorElem, "textColor");
            this.addColor(mainColor, lightColor, darkColor, textColor);
        }
    }

    private void addColor(String main, String light, String dark, String text) {
        this.colors.add(new String[]{main, light, dark, text});
    }

    public String[] getNextSwatche() {
        if (this.colorIterator == null || !this.colorIterator.hasNext()) {
            this.colorIterator = this.colors.iterator();
        }
        return this.colorIterator.next();
    }

    public String getNextColor() {
        if (this.colorIterator != null && !this.colorIterator.hasNext()) {
            this.toneIndex = this.toneIndex < 2 ? ++this.toneIndex : 0;
        }
        return this.getNextSwatche()[this.toneIndex];
    }
}

