/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.util.print.printer;

import br.com.sankhya.sps.business.model.Job;
import br.com.sankhya.sps.print.exception.PrintErrorCode;
import br.com.sankhya.sps.print.exception.PrintException;
import br.com.sankhya.sps.util.print.DocumentPrinter;
import java.nio.charset.Charset;
import java.util.Locale;
import javax.inject.Inject;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.FlavorException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.DocumentName;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.PrintQuality;
import javax.print.event.PrintJobListener;
import org.apache.log4j.Logger;

public class TextDocumentPrinter
implements DocumentPrinter {
    private static Logger log = Logger.getLogger(TextDocumentPrinter.class);
    private Job job;
    private PrintJobListener listener;
    private PrintService printService;
    private String textDoc;
    private DocFlavor docFlavor;

    @Inject
    public TextDocumentPrinter(String textDoc, Job job, PrintJobListener listener, PrintService printService, DocFlavor docFlavor) {
        this.job = job;
        this.listener = listener;
        this.printService = printService;
        this.textDoc = textDoc;
        this.docFlavor = docFlavor;
    }

    @Override
    public void print() {
        try {
            PrintRequestAttributeSet aset = this.createPrintRequestAttributeSet();
            DocAttributeSet dset = this.createDocAttributeSet();
            log.debug((Object)("+++++++++ JOB: " + this.job));
            log.debug((Object)("+++++++++ DocFlavor: " + this.docFlavor));
            byte[] textBytes = this.textDoc.getBytes(Charset.forName("ISO-8859-1"));
            SimpleDoc doc = new SimpleDoc(textBytes, this.docFlavor, dset);
            for (int i = 1; i <= this.job.getCopies(); ++i) {
                DocPrintJob docPrintJob = this.printService.createPrintJob();
                docPrintJob.addPrintJobListener(this.listener);
                docPrintJob.print(doc, aset);
            }
        }
        catch (Exception e) {
            if (e instanceof FlavorException) {
                throw new PrintException(PrintErrorCode.UNSUPPORTED_DOCFLAFOR, (Throwable)e);
            }
            throw new PrintException(PrintErrorCode.PRINT_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    private DocAttributeSet createDocAttributeSet() {
        String fileName = this.job.getFileName();
        HashDocAttributeSet dset = new HashDocAttributeSet();
        DocumentName documentName = new DocumentName(fileName, Locale.getDefault());
        dset.add(documentName);
        return dset;
    }

    private PrintRequestAttributeSet createPrintRequestAttributeSet() {
        String fileName = this.job.getFileName();
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        aset.add(PrintQuality.HIGH);
        aset.add(new JobName(fileName, Locale.getDefault()));
        return aset;
    }
}

