/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.util.print.printer;

import br.com.sankhya.sps.business.model.Job;
import br.com.sankhya.sps.print.exception.PrintErrorCode;
import br.com.sankhya.sps.util.print.DocumentPrinter;
import br.com.sankhya.sps.util.print.printer.PageableText;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.util.Locale;
import javax.inject.Inject;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.FlavorException;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.DocumentName;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.PrintQuality;
import javax.print.event.PrintJobListener;
import org.apache.log4j.Logger;

public class PrintableTextDocumentPrinter
implements DocumentPrinter {
    private static Logger log = Logger.getLogger(PrintableTextDocumentPrinter.class);
    private Job job;
    private PrintJobListener listener;
    private PrintService printService;
    private String textDoc;
    private DocFlavor docFlavor;

    @Inject
    public PrintableTextDocumentPrinter(String textToPrint, Job job, PrintJobListener listener, PrintService printService, DocFlavor docFlavor) {
        this.job = job;
        this.listener = listener;
        this.printService = printService;
        this.textDoc = textToPrint;
        this.docFlavor = docFlavor;
    }

    @Override
    public void print() {
        try {
            PageFormat format = new PageFormat();
            PageableText pageable = new PageableText(this.textDoc, format);
            PrintRequestAttributeSet aset = this.createPrintRequestAttributeSet();
            DocAttributeSet dset = this.createDocAttributeSet();
            log.debug((Object)("+++++++++ JOB: " + this.job));
            log.debug((Object)("+++++++++ DocFlavor: " + this.docFlavor));
            SimpleDoc doc = new SimpleDoc(pageable, DocFlavor.SERVICE_FORMATTED.PRINTABLE, dset);
            for (int i = 1; i <= this.job.getCopies(); ++i) {
                DocPrintJob docPrintJob = this.printService.createPrintJob();
                docPrintJob.addPrintJobListener(this.listener);
                docPrintJob.print(doc, aset);
            }
        }
        catch (PrintException e) {
            if (e instanceof FlavorException) {
                throw new br.com.sankhya.sps.print.exception.PrintException(PrintErrorCode.UNSUPPORTED_DOCFLAFOR, (Throwable)e);
            }
            throw new br.com.sankhya.sps.print.exception.PrintException(PrintErrorCode.PRINT_ERROR, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new br.com.sankhya.sps.print.exception.PrintException(PrintErrorCode.FILE_NOT_FOUND, (Throwable)e);
        }
    }

    private DocAttributeSet createDocAttributeSet() {
        String fileName = this.job.getFileName();
        HashDocAttributeSet dset = new HashDocAttributeSet();
        DocumentName documentName = new DocumentName(fileName, Locale.getDefault());
        dset.add(documentName);
        return dset;
    }

    private PrintRequestAttributeSet createPrintRequestAttributeSet() {
        String fileName = this.job.getFileName();
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        aset.add(PrintQuality.HIGH);
        aset.add(new JobName(fileName, Locale.getDefault()));
        return aset;
    }
}

