/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.util.print.printer;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;

public class PageableText
implements Pageable,
Printable {
    public static String FONTFAMILY = "Monospaced";
    public static int FONTSIZE = 10;
    public static int FONTSTYLE = 0;
    public static float LINESPACEFACTOR = 1.1f;
    private PageFormat format;
    private Vector lines;
    private Font font;
    private int linespacing;
    private int linesPerPage;
    private int numPages;
    private int baseline = -1;

    public PageableText(String text, PageFormat format) throws IOException {
        this(new StringReader(text), format);
    }

    public PageableText(File file, PageFormat format) throws IOException {
        this(new FileReader(file), format);
    }

    public PageableText(Reader stream, PageFormat format) throws IOException {
        String line;
        this.format = format;
        BufferedReader in = new BufferedReader(stream);
        this.lines = new Vector();
        while ((line = in.readLine()) != null) {
            this.lines.addElement(line);
        }
        this.font = new Font(FONTFAMILY, FONTSTYLE, FONTSIZE);
        this.linespacing = (int)((float)FONTSIZE * LINESPACEFACTOR);
        this.linesPerPage = (int)Math.floor(format.getImageableHeight() / (double)this.linespacing);
        this.numPages = (this.lines.size() - 1) / this.linesPerPage + 1;
    }

    @Override
    public int getNumberOfPages() {
        return this.numPages;
    }

    @Override
    public PageFormat getPageFormat(int pagenum) {
        return this.format;
    }

    @Override
    public Printable getPrintable(int pagenum) {
        return this;
    }

    @Override
    public int print(Graphics g, PageFormat format, int pagenum) {
        if (pagenum < 0 | pagenum >= this.numPages) {
            return 1;
        }
        if (this.baseline == -1) {
            FontMetrics fm = g.getFontMetrics(this.font);
            this.baseline = fm.getAscent();
        }
        g.setColor(Color.white);
        g.fillRect((int)format.getImageableX(), (int)format.getImageableY(), (int)format.getImageableWidth(), (int)format.getImageableHeight());
        g.setFont(this.font);
        g.setColor(Color.black);
        int startLine = pagenum * this.linesPerPage;
        int endLine = startLine + this.linesPerPage - 1;
        if (endLine >= this.lines.size()) {
            endLine = this.lines.size() - 1;
        }
        int x0 = (int)format.getImageableX();
        int y0 = (int)format.getImageableY() + this.baseline;
        for (int i = startLine; i <= endLine; ++i) {
            String line = (String)this.lines.elementAt(i);
            if (line.length() > 0) {
                g.drawString(line, x0, y0);
            }
            y0 += this.linespacing;
        }
        return 0;
    }
}

