/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.util.print.printer;

import br.com.sankhya.sps.business.model.Job;
import br.com.sankhya.sps.business.service.JobService;
import br.com.sankhya.sps.enumeration.JobStatus;
import br.com.sankhya.sps.print.exception.PrintErrorCode;
import br.com.sankhya.sps.print.exception.PrintException;
import br.com.sankhya.sps.util.print.DocumentPrinter;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.DocumentName;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.PrintQuality;
import javax.print.event.PrintJobListener;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.print.JRPrinterAWT;
import org.apache.log4j.Logger;

public class JasperPrintDocumentPrinter
extends JRPrinterAWT
implements DocumentPrinter {
    private static Logger log = Logger.getLogger(JasperPrintDocumentPrinter.class);
    private Job job;
    private PrintJobListener listener;
    private PrintService printService;
    private JasperPrint jasperPrint;
    private DocFlavor docFlavor;
    private JobService jobService;
    private String gsPath;

    public JasperPrintDocumentPrinter(Job job, JasperPrint jasperPrint, PrintJobListener listener, PrintService printService, DocFlavor docFlavor, JobService jobService, String ghostscriptPath) throws JRException {
        super(jasperPrint);
        this.job = job;
        this.listener = listener;
        this.printService = printService;
        this.jasperPrint = jasperPrint;
        this.docFlavor = docFlavor;
        this.gsPath = ghostscriptPath;
        this.jobService = jobService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printGhostScript() throws Exception {
        FileOutputStream fos = null;
        File pdfTempFile = null;
        try {
            File tempDir = new File(System.getProperty("user.home"), ".sps-temp-pdf");
            if (!tempDir.exists()) {
                tempDir.mkdirs();
            }
            pdfTempFile = new File(tempDir.getAbsolutePath(), this.job.getFileName() + ".pdf");
            fos = new FileOutputStream(pdfTempFile);
            JasperExportManager.exportReportToPdfStream((JasperPrint)this.jasperPrint, (OutputStream)fos);
            fos.flush();
            fos.close();
            Process execution = Runtime.getRuntime().exec(this.gsPath + " -sDEVICE=mswinpr2 -dQUIET -dBATCH -dNOPAUSE -dSAFER -sOutputFile=\"%printer%" + this.printService.getName() + "\" " + pdfTempFile.getAbsolutePath());
            execution.waitFor();
            this.jobService.updateJobStatus(this.job, JobStatus.DONE, "IMPRESS\u00c3O COMPLETA");
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception ignored) {}
            }
            if (pdfTempFile != null) {
                try {
                    pdfTempFile.delete();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void print() {
        try {
            if (this.gsPath != null && this.gsPath.trim().length() > 0) {
                this.printGhostScript();
                return;
            }
            PrinterJob printerJob = this.createPrinterJob();
            PageFormat pageFormat = this.createPageFormat(printerJob);
            Book book = this.createBook(pageFormat);
            printerJob.setPageable(book);
            try {
                for (int i = 1; i <= this.job.getCopies(); ++i) {
                    printerJob.print();
                }
                this.jobService.updateJobStatus(this.job, JobStatus.DONE, "IMPRESS\u00c3O COMPLETA");
            }
            catch (Exception printException) {
                this.jobService.updateJobStatus(this.job, JobStatus.ERROR, "IMPRESS\u00c3O FALHOU");
                printException.printStackTrace();
            }
            log.debug((Object)("+++++++++ JOB: " + this.job));
            log.debug((Object)("+++++++++ DocFlavor: " + this.docFlavor));
        }
        catch (Exception e) {
            throw new PrintException(PrintErrorCode.PRINT_ERROR, (Throwable)e);
        }
    }

    private Book createBook(PageFormat pageFormat) {
        Book book = new Book();
        book.append((Printable)((Object)this), pageFormat, this.jasperPrint.getPages().size());
        return book;
    }

    private PrinterJob createPrinterJob() throws PrinterException {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintService(this.printService);
        return printJob;
    }

    private PrintRequestAttributeSet createPrintRequestAttributeSet(Job job) {
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        aset.add(new Copies(this.job.getCopies()));
        aset.add(PrintQuality.HIGH);
        aset.add(new JobName(job.getFileName(), Locale.US));
        return aset;
    }

    private DocAttributeSet createDocAttributSet() {
        HashDocAttributeSet dset = new HashDocAttributeSet();
        String fileName = this.job.getFileName();
        DocumentName documentName = new DocumentName(fileName, Locale.US);
        dset.add(documentName);
        return dset;
    }

    private PageFormat createPageFormat(PrinterJob printJob) {
        PageFormat pageFormat = printJob.defaultPage();
        Paper paper = pageFormat.getPaper();
        switch (this.jasperPrint.getOrientationValue()) {
            case LANDSCAPE: {
                pageFormat.setOrientation(0);
                paper.setSize(this.jasperPrint.getPageHeight(), this.jasperPrint.getPageWidth());
                paper.setImageableArea(0.0, 0.0, this.jasperPrint.getPageHeight(), this.jasperPrint.getPageWidth());
                break;
            }
            case PORTRAIT: {
                pageFormat.setOrientation(1);
                paper.setSize(this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
                paper.setImageableArea(0.0, 0.0, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
            }
        }
        pageFormat.setPaper(paper);
        return pageFormat;
    }
}

