/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.util.print.printer;

import br.com.sankhya.sps.business.model.Job;
import br.com.sankhya.sps.enumeration.DocTaste;
import br.com.sankhya.sps.print.exception.PrintErrorCode;
import br.com.sankhya.sps.print.exception.PrintException;
import br.com.sankhya.sps.util.print.DocumentPrinter;
import java.awt.print.Pageable;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.inject.Inject;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.FlavorException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.DocumentName;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.PrintQuality;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPageable;

public class AutoSenseDocumentPrinter
implements DocumentPrinter {
    private static Logger log = Logger.getLogger(AutoSenseDocumentPrinter.class);
    private Job job;
    private PrintJobListener listener;
    private PrintService printService;
    private InputStream inputStream;
    private DocFlavor docFlavor;
    private PDDocument document;

    @Inject
    public AutoSenseDocumentPrinter(InputStream inputStream, Job job, PrintJobListener listener, PrintService printService, DocFlavor docFlavor) {
        this.job = job;
        this.listener = listener;
        this.printService = printService;
        this.inputStream = inputStream;
        this.docFlavor = docFlavor;
    }

    @Override
    public void print() {
        block23: {
            try {
                PrintRequestAttributeSet aset = this.createPrintRequestAttributeSet();
                DocAttributeSet dset = this.createDocAttributeSet();
                log.debug((Object)("+++++++++ JOB: " + this.job));
                log.debug((Object)("+++++++++ DocFlavor: " + this.docFlavor));
                if (this.job.getDocTaste() == DocTaste.PDF) {
                    try {
                        this.document = PDDocument.load((InputStream)this.inputStream);
                        for (int i = 1; i <= this.job.getCopies(); ++i) {
                            PrinterJob printerJob = PrinterJob.getPrinterJob();
                            printerJob.setPrintService(this.printService);
                            printerJob.setPageable((Pageable)new PDFPageable(this.document));
                            printerJob.print(aset);
                        }
                        this.listener.printJobCompleted(new PrintJobEvent(this.printService.createPrintJob(), 102));
                        break block23;
                    }
                    catch (Exception e) {
                        this.listener.printJobFailed(new PrintJobEvent(this.printService.createPrintJob(), 103));
                        throw new PrintException(PrintErrorCode.PRINT_ERROR, e.getMessage(), (Throwable)e);
                    }
                    finally {
                        if (this.document != null) {
                            try {
                                this.document.close();
                            }
                            catch (Exception ignored) {}
                        }
                    }
                }
                for (int i = 1; i <= this.job.getCopies(); ++i) {
                    SimpleDoc doc = new SimpleDoc(this.inputStream, this.docFlavor, dset);
                    DocPrintJob docPrintJob = this.printService.createPrintJob();
                    docPrintJob.addPrintJobListener(this.listener);
                    docPrintJob.print(doc, aset);
                }
            }
            catch (Exception e) {
                if (e instanceof FlavorException) {
                    throw new PrintException(PrintErrorCode.UNSUPPORTED_DOCFLAFOR, (Throwable)e);
                }
                throw new PrintException(PrintErrorCode.PRINT_ERROR, e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private DocAttributeSet createDocAttributeSet() {
        String fileName = this.job.getFileName();
        HashDocAttributeSet dset = new HashDocAttributeSet();
        DocumentName documentName = new DocumentName(fileName, Locale.US);
        dset.add(documentName);
        return dset;
    }

    private PrintRequestAttributeSet createPrintRequestAttributeSet() {
        String fileName = this.job.getFileName();
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        aset.add(PrintQuality.HIGH);
        aset.add(new JobName(fileName, Locale.US));
        return aset;
    }
}

