/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.util.print.loader;

import br.com.sankhya.sps.business.model.Job;
import br.com.sankhya.sps.conversion.ConversionUtil;
import br.com.sankhya.sps.util.JobUtil;
import br.com.sankhya.sps.util.print.loader.DocumentLoader;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.inject.Inject;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

@Singleton
public class JasperPrintDocumentLoader
implements DocumentLoader<JasperPrint> {
    private JobUtil jobUtil;
    private ConversionUtil conversionUtil;

    @Inject
    public JasperPrintDocumentLoader(JobUtil jobUtil, ConversionUtil conversionUtil) {
        this.jobUtil = jobUtil;
        this.conversionUtil = conversionUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JasperPrint load(Job job) throws Exception {
        FileInputStream inputStream = null;
        try {
            String filePath = this.jobUtil.getFilePath(job);
            File file = new File(filePath);
            inputStream = FileUtils.openInputStream((File)file);
            byte[] byteArray = IOUtils.toByteArray((InputStream)inputStream);
            JasperPrint jasperPrint = (JasperPrint)this.conversionUtil.convert((Object)byteArray, JasperPrint.class);
            jasperPrint.setProperty("net.sf.jasperreports.awt.ignore.missing.font", "true");
            JasperPrint jasperPrint2 = jasperPrint;
            return jasperPrint2;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

