/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.util.print.listener;

import br.com.sankhya.sps.business.exception.BusinessException;
import br.com.sankhya.sps.business.model.Job;
import br.com.sankhya.sps.business.service.JobService;
import br.com.sankhya.sps.enumeration.JobStatus;
import javax.print.event.PrintJobAdapter;
import javax.print.event.PrintJobEvent;
import org.apache.log4j.Logger;

public class PrintJobStatusListener
extends PrintJobAdapter {
    private static Logger log = Logger.getLogger(PrintJobStatusListener.class);
    private Job job;
    private JobService jobService;

    public PrintJobStatusListener(Job job, JobService jobService) {
        this.job = job;
        this.jobService = jobService;
    }

    private void updateStatus(JobStatus jobStatus, String statusMessage) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)this.job);
                log.debug((Object)String.format("Novo Status: %s | Nova Mensagem: %s", jobStatus, statusMessage));
            }
            this.jobService.updateJobStatus(this.job, jobStatus, statusMessage);
        }
        catch (BusinessException e) {
            log.warn((Object)("N\u00e3o foi poss\u00edvel atualizar o status do Job para" + jobStatus), (Throwable)((Object)e));
        }
    }

    @Override
    public void printJobCanceled(PrintJobEvent pje) {
        super.printJobCanceled(pje);
        this.updateStatus(JobStatus.CANCELED, "IMPRESS\u00c3O CANCELADA");
    }

    @Override
    public void printJobCompleted(PrintJobEvent pje) {
        super.printJobCompleted(pje);
        this.updateStatus(JobStatus.DONE, "IMPRESS\u00c3O COMPLETA");
    }

    @Override
    public void printJobFailed(PrintJobEvent pje) {
        super.printJobFailed(pje);
        this.updateStatus(JobStatus.ERROR, "IMPRESS\u00c3O FALHOU");
    }

    @Override
    public void printJobNoMoreEvents(PrintJobEvent pje) {
        super.printJobNoMoreEvents(pje);
        this.updateStatus(JobStatus.DONE, "IMPRESS\u00c3O COMPLETA");
    }

    @Override
    public void printJobRequiresAttention(PrintJobEvent pje) {
        super.printJobRequiresAttention(pje);
        this.updateStatus(JobStatus.REQUIRE_ATTENTION, "IMPRESSORA REQUER SUA ATEN\u00c7\u00c3O");
    }

    @Override
    public void printDataTransferCompleted(PrintJobEvent pje) {
        super.printDataTransferCompleted(pje);
        this.updateStatus(JobStatus.PRINTING, "IMPRESS\u00c3O INICIADA");
    }
}

