/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.util.print.builder;

import br.com.sankhya.sps.annotation.type.loader.TextDoc;
import br.com.sankhya.sps.business.model.Job;
import br.com.sankhya.sps.business.service.JobService;
import br.com.sankhya.sps.print.exception.PrintErrorCode;
import br.com.sankhya.sps.print.exception.PrintException;
import br.com.sankhya.sps.util.JobUtil;
import br.com.sankhya.sps.util.PrintServiceUtil;
import br.com.sankhya.sps.util.print.DocumentPrinter;
import br.com.sankhya.sps.util.print.DocumentPrinterBuilder;
import br.com.sankhya.sps.util.print.listener.PrintJobStatusListener;
import br.com.sankhya.sps.util.print.loader.DocumentLoader;
import br.com.sankhya.sps.util.print.printer.TextDocumentPrinter;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.print.DocFlavor;
import javax.print.PrintService;

public class TextDocumentPrinterBuilder
implements DocumentPrinterBuilder {
    private Provider<JobService> jobServiceProvider;
    private DocumentLoader<String> documentLoader;
    private PrintServiceUtil printServiceUtil;
    private JobUtil jobUtil;

    @Inject
    TextDocumentPrinterBuilder(Provider<JobService> jobServiceProvider, @TextDoc DocumentLoader<String> documentLoader, PrintServiceUtil printServiceUtil, JobUtil jobUtil) {
        this.jobServiceProvider = jobServiceProvider;
        this.documentLoader = documentLoader;
        this.printServiceUtil = printServiceUtil;
        this.jobUtil = jobUtil;
    }

    @Override
    public DocumentPrinter create(Job job) {
        try {
            String textToPrint = this.documentLoader.load(job);
            JobService jobService = (JobService)this.jobServiceProvider.get();
            PrintJobStatusListener listener = new PrintJobStatusListener(job, jobService);
            PrintService printService = this.printServiceUtil.getPrintService(job);
            DocFlavor docFlavor = this.jobUtil.getDocFlavor(job);
            return new TextDocumentPrinter(textToPrint, job, listener, printService, docFlavor);
        }
        catch (Exception e) {
            throw new PrintException(PrintErrorCode.PRINT_ERROR);
        }
    }
}

