/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.util.print.builder;

import br.com.sankhya.sps.annotation.configuration.ConfigGhostScriptPath;
import br.com.sankhya.sps.annotation.type.loader.Jasper;
import br.com.sankhya.sps.business.model.Job;
import br.com.sankhya.sps.business.service.JobService;
import br.com.sankhya.sps.print.exception.PrintErrorCode;
import br.com.sankhya.sps.print.exception.PrintException;
import br.com.sankhya.sps.util.JobUtil;
import br.com.sankhya.sps.util.PrintServiceUtil;
import br.com.sankhya.sps.util.print.DocumentPrinter;
import br.com.sankhya.sps.util.print.DocumentPrinterBuilder;
import br.com.sankhya.sps.util.print.listener.PrintJobStatusListener;
import br.com.sankhya.sps.util.print.loader.DocumentLoader;
import br.com.sankhya.sps.util.print.printer.JasperPrintDocumentPrinter;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.print.DocFlavor;
import javax.print.PrintService;
import net.sf.jasperreports.engine.JasperPrint;

public class JasperPrintDocumentPrinterBuilder
implements DocumentPrinterBuilder {
    private Provider<JobService> jobServiceProvider;
    private DocumentLoader<JasperPrint> documentLoader;
    private PrintServiceUtil printServiceUtil;
    private JobUtil jobUtil;
    @Inject
    @ConfigGhostScriptPath
    private String gsPath;

    @Inject
    JasperPrintDocumentPrinterBuilder(Provider<JobService> jobServiceProvider, @Jasper DocumentLoader<JasperPrint> documentLoader, PrintServiceUtil printServiceUtil, JobUtil jobUtil) {
        this.jobServiceProvider = jobServiceProvider;
        this.documentLoader = documentLoader;
        this.printServiceUtil = printServiceUtil;
        this.jobUtil = jobUtil;
    }

    @Override
    public DocumentPrinter create(Job job) {
        try {
            JasperPrint jasperPrint = this.documentLoader.load(job);
            PrintService printService = this.printServiceUtil.getPrintService(job);
            PrintJobStatusListener listener = new PrintJobStatusListener(job, (JobService)this.jobServiceProvider.get());
            DocFlavor docFlavor = this.jobUtil.getDocFlavor(job);
            JobService jobService = (JobService)this.jobServiceProvider.get();
            return new JasperPrintDocumentPrinter(job, jasperPrint, listener, printService, docFlavor, jobService, this.gsPath);
        }
        catch (Exception e) {
            throw new PrintException(PrintErrorCode.PRINT_ERROR, (Throwable)e);
        }
    }
}

